/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.bukkit.util.CommandInfo;
import com.sk89q.bukkit.util.CommandRegistration;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.worldedit.BiomeTypes;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.bukkit.BukkitBiomeTypes;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class BukkitServerInterface
extends ServerInterface {
    public Server server;
    public WorldEditPlugin plugin;
    private CommandRegistration dynamicCommands;
    private BukkitBiomeTypes biomes;

    public BukkitServerInterface(WorldEditPlugin plugin, Server server) {
        this.plugin = plugin;
        this.server = server;
        this.biomes = new BukkitBiomeTypes();
        this.dynamicCommands = new CommandRegistration((Plugin)plugin);
    }

    @Override
    public int resolveItem(String name) {
        Material mat = Material.matchMaterial((String)name);
        return mat == null ? 0 : mat.getId();
    }

    @Override
    public boolean isValidMobType(String type) {
        EntityType entityType = EntityType.fromName((String)type);
        return entityType != null && entityType.isAlive();
    }

    @Override
    public void reload() {
        this.plugin.loadConfiguration();
    }

    @Override
    public BiomeTypes getBiomes() {
        return this.biomes;
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        return Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, task, delay, period);
    }

    @Override
    public List<LocalWorld> getWorlds() {
        List worlds = this.server.getWorlds();
        ArrayList<LocalWorld> ret = new ArrayList<LocalWorld>(worlds.size());
        for (World world : worlds) {
            ret.add(BukkitUtil.getLocalWorld(world));
        }
        return ret;
    }

    @Override
    public void onCommandRegistration(List<Command> commands, CommandsManager<LocalPlayer> manager) {
        ArrayList<CommandInfo> toRegister = new ArrayList<CommandInfo>();
        for (Command command : commands) {
            String[] permissions = null;
            Method cmdMethod = manager.getMethods().get(null).get(command.aliases()[0]);
            if (cmdMethod != null && cmdMethod.isAnnotationPresent(CommandPermissions.class)) {
                permissions = cmdMethod.getAnnotation(CommandPermissions.class).value();
            }
            toRegister.add(new CommandInfo(command.usage(), command.desc(), command.aliases(), manager, permissions));
        }
        this.dynamicCommands.register(toRegister);
    }

    public void unregisterCommands() {
        this.dynamicCommands.unregisterCommands();
    }
}

