/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.NmsBlock;
import com.sk89q.worldedit.data.DataException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.server.v1_6_R3.Block;
import net.minecraft.server.v1_6_R3.NBTBase;
import net.minecraft.server.v1_6_R3.NBTTagByte;
import net.minecraft.server.v1_6_R3.NBTTagByteArray;
import net.minecraft.server.v1_6_R3.NBTTagCompound;
import net.minecraft.server.v1_6_R3.NBTTagDouble;
import net.minecraft.server.v1_6_R3.NBTTagEnd;
import net.minecraft.server.v1_6_R3.NBTTagFloat;
import net.minecraft.server.v1_6_R3.NBTTagInt;
import net.minecraft.server.v1_6_R3.NBTTagIntArray;
import net.minecraft.server.v1_6_R3.NBTTagList;
import net.minecraft.server.v1_6_R3.NBTTagLong;
import net.minecraft.server.v1_6_R3.NBTTagShort;
import net.minecraft.server.v1_6_R3.NBTTagString;
import net.minecraft.server.v1_6_R3.TileEntity;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;

public class DefaultNmsBlock
extends NmsBlock {
    private static final Logger logger;
    private static Field compoundMapField;
    private static final Field nmsBlock_isTileEntityField;
    private NBTTagCompound nbtData = null;

    public static boolean verify() {
        return nmsBlock_isTileEntityField != null;
    }

    public DefaultNmsBlock(int type, int data, TileEntityBlock tileEntityBlock) {
        super(type, data);
        this.nbtData = (NBTTagCompound)DefaultNmsBlock.fromNative(tileEntityBlock.getNbtData());
    }

    public DefaultNmsBlock(int type, int data, NBTTagCompound nbtData) {
        super(type, data);
        this.nbtData = nbtData;
    }

    private NBTTagCompound getNmsData(Vector pt) {
        if (this.nbtData == null) {
            return null;
        }
        this.nbtData.set("x", (NBTBase)new NBTTagInt("x", pt.getBlockX()));
        this.nbtData.set("y", (NBTBase)new NBTTagInt("y", pt.getBlockY()));
        this.nbtData.set("z", (NBTBase)new NBTTagInt("z", pt.getBlockZ()));
        return this.nbtData;
    }

    @Override
    public boolean hasNbtData() {
        return this.nbtData != null;
    }

    @Override
    public String getNbtId() {
        if (this.nbtData == null) {
            return "";
        }
        return this.nbtData.getString("id");
    }

    @Override
    public CompoundTag getNbtData() {
        if (this.nbtData == null) {
            return new CompoundTag(this.getNbtId(), new HashMap<String, Tag>());
        }
        return (CompoundTag)DefaultNmsBlock.toNative((NBTBase)this.nbtData);
    }

    @Override
    public void setNbtData(CompoundTag tag) throws DataException {
        if (tag == null) {
            this.nbtData = null;
        }
        this.nbtData = (NBTTagCompound)DefaultNmsBlock.fromNative(tag);
    }

    public static DefaultNmsBlock get(World world, Vector position, int type, int data) {
        if (!DefaultNmsBlock.hasTileEntity(type)) {
            return null;
        }
        TileEntity te = ((CraftWorld)world).getHandle().getTileEntity(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.b(tag);
            return new DefaultNmsBlock(type, data, tag);
        }
        return null;
    }

    public static boolean set(World world, Vector position, BaseBlock block) {
        TileEntity te;
        DefaultNmsBlock nmsProxyBlock;
        NBTTagCompound data = null;
        if (!DefaultNmsBlock.hasTileEntity(world.getBlockTypeIdAt(position.getBlockX(), position.getBlockY(), position.getBlockZ()))) {
            return false;
        }
        if (block instanceof DefaultNmsBlock) {
            nmsProxyBlock = (DefaultNmsBlock)block;
            data = nmsProxyBlock.getNmsData(position);
        } else if (block instanceof TileEntityBlock) {
            nmsProxyBlock = new DefaultNmsBlock(block.getId(), block.getData(), block);
            data = nmsProxyBlock.getNmsData(position);
        }
        if (data != null && (te = ((CraftWorld)world).getHandle().getTileEntity(position.getBlockX(), position.getBlockY(), position.getBlockZ())) != null) {
            te.a(data);
            return true;
        }
        return false;
    }

    public static boolean setSafely(BukkitWorld world, Vector position, com.sk89q.worldedit.foundation.Block block, boolean notifyAdjacent) {
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        CraftWorld craftWorld = (CraftWorld)world.getWorld();
        boolean changed = craftWorld.getHandle().setTypeIdAndData(x, y, z, block.getId(), block.getData(), 0);
        if (block instanceof BaseBlock) {
            world.copyToWorld(position, (BaseBlock)block);
        }
        boolean bl = changed = craftWorld.getHandle().setData(x, y, z, block.getData(), 0) || changed;
        if (changed && notifyAdjacent) {
            craftWorld.getHandle().notify(x, y, z);
            craftWorld.getHandle().update(x, y, z, block.getId());
        }
        return changed;
    }

    public static boolean hasTileEntity(int type) {
        Block nmsBlock = DefaultNmsBlock.getNmsBlock(type);
        if (nmsBlock == null) {
            return false;
        }
        try {
            return nmsBlock_isTileEntityField.getBoolean(nmsBlock);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public static Block getNmsBlock(int type) {
        if (type < 0 || type >= Block.byId.length) {
            return null;
        }
        return Block.byId[type];
    }

    private static Tag toNative(NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            Collection foreignValues = null;
            if (compoundMapField == null) {
                try {
                    foreignValues = ((NBTTagCompound)foreign).c();
                }
                catch (Throwable t) {
                    try {
                        logger.warning("WorldEdit: Couldn't get NBTTagCompound.c(), so we're going to try to get at the 'map' field directly from now on");
                        if (compoundMapField == null) {
                            compoundMapField = NBTTagCompound.class.getDeclaredField("map");
                            compoundMapField.setAccessible(true);
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (compoundMapField != null) {
                try {
                    foreignValues = ((HashMap)compoundMapField.get(foreign)).values();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            for (Object obj : foreignValues) {
                NBTBase base = (NBTBase)obj;
                values.put(base.getName(), DefaultNmsBlock.toNative(base));
            }
            return new CompoundTag(foreign.getName(), values);
        }
        if (foreign instanceof NBTTagByte) {
            return new ByteTag(foreign.getName(), ((NBTTagByte)foreign).data);
        }
        if (foreign instanceof NBTTagByteArray) {
            return new ByteArrayTag(foreign.getName(), ((NBTTagByteArray)foreign).data);
        }
        if (foreign instanceof NBTTagDouble) {
            return new DoubleTag(foreign.getName(), ((NBTTagDouble)foreign).data);
        }
        if (foreign instanceof NBTTagFloat) {
            return new FloatTag(foreign.getName(), ((NBTTagFloat)foreign).data);
        }
        if (foreign instanceof NBTTagInt) {
            return new IntTag(foreign.getName(), ((NBTTagInt)foreign).data);
        }
        if (foreign instanceof NBTTagIntArray) {
            return new IntArrayTag(foreign.getName(), ((NBTTagIntArray)foreign).data);
        }
        if (foreign instanceof NBTTagList) {
            ArrayList<Tag> values = new ArrayList<Tag>();
            NBTTagList foreignList = (NBTTagList)foreign;
            int type = 1;
            for (int i = 0; i < foreignList.size(); ++i) {
                NBTBase foreignTag = foreignList.get(i);
                values.add(DefaultNmsBlock.toNative(foreignTag));
                type = foreignTag.getTypeId();
            }
            Class<? extends Tag> cls = NBTConstants.getClassFromType(type);
            return new ListTag(foreign.getName(), cls, values);
        }
        if (foreign instanceof NBTTagLong) {
            return new LongTag(foreign.getName(), ((NBTTagLong)foreign).data);
        }
        if (foreign instanceof NBTTagShort) {
            return new ShortTag(foreign.getName(), ((NBTTagShort)foreign).data);
        }
        if (foreign instanceof NBTTagString) {
            return new StringTag(foreign.getName(), ((NBTTagString)foreign).data);
        }
        if (foreign instanceof NBTTagEnd) {
            return new EndTag();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private static NBTBase fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            NBTTagCompound tag = new NBTTagCompound(foreign.getName());
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                tag.set((String)entry.getKey(), DefaultNmsBlock.fromNative((Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return new NBTTagByte(foreign.getName(), ((ByteTag)foreign).getValue().byteValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return new NBTTagByteArray(foreign.getName(), ((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return new NBTTagDouble(foreign.getName(), ((DoubleTag)foreign).getValue().doubleValue());
        }
        if (foreign instanceof FloatTag) {
            return new NBTTagFloat(foreign.getName(), ((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return new NBTTagInt(foreign.getName(), ((IntTag)foreign).getValue().intValue());
        }
        if (foreign instanceof IntArrayTag) {
            return new NBTTagIntArray(foreign.getName(), ((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            NBTTagList tag = new NBTTagList(foreign.getName());
            ListTag foreignList = (ListTag)foreign;
            Iterator i$ = foreignList.getValue().iterator();
            while (i$.hasNext()) {
                Tag t = (Tag)i$.next();
                tag.add(DefaultNmsBlock.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return new NBTTagLong(foreign.getName(), ((LongTag)foreign).getValue().longValue());
        }
        if (foreign instanceof ShortTag) {
            return new NBTTagShort(foreign.getName(), ((ShortTag)foreign).getValue().shortValue());
        }
        if (foreign instanceof StringTag) {
            return new NBTTagString(foreign.getName(), ((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            return new NBTTagEnd();
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }

    public static boolean isValidBlockType(int type) throws NoClassDefFoundError {
        return type == 0 || type >= 1 && type < Block.byId.length && Block.byId[type] != null;
    }

    static {
        Field field;
        logger = WorldEdit.logger;
        try {
            field = Block.class.getDeclaredField("isTileEntity");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        nmsBlock_isTileEntityField = field;
    }
}

