/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.masks.Mask;

public class HistoryCommands {
    private final WorldEdit we;

    public HistoryCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/undo", "undo"}, usage="[times] [player]", desc="Undoes the last action", min=0, max=2)
    @CommandPermissions(value={"worldedit.history.undo"})
    public void undo(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int times = Math.max(1, args.getInteger(0, 1));
        Mask mask = session.getMask();
        session.setMask(null);
        for (int i = 0; i < times; ++i) {
            EditSession undone;
            if (args.argsLength() < 2) {
                undone = session.undo(session.getBlockBag(player), player);
            } else {
                player.checkPermission("worldedit.history.undo.other");
                LocalSession sess = this.we.getSession(args.getString(1));
                if (sess == null) {
                    player.printError("Unable to find session for " + args.getString(1));
                    break;
                }
                undone = sess.undo(session.getBlockBag(player), player);
            }
            if (undone == null) {
                player.printError("Nothing left to undo.");
                break;
            }
            player.print("Undo successful.");
            this.we.flushBlockBag(player, undone);
        }
        session.setMask(mask);
    }

    @Command(aliases={"/redo", "redo"}, usage="[times] [player]", desc="Redoes the last action (from history)", min=0, max=2)
    @CommandPermissions(value={"worldedit.history.redo"})
    public void redo(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int times = Math.max(1, args.getInteger(0, 1));
        Mask mask = session.getMask();
        session.setMask(null);
        for (int i = 0; i < times; ++i) {
            EditSession redone;
            if (args.argsLength() < 2) {
                redone = session.redo(session.getBlockBag(player), player);
            } else {
                player.checkPermission("worldedit.history.redo.other");
                LocalSession sess = this.we.getSession(args.getString(1));
                if (sess == null) {
                    player.printError("Unable to find session for " + args.getString(1));
                    break;
                }
                redone = sess.redo(session.getBlockBag(player), player);
            }
            if (redone != null) {
                player.print("Redo successful.");
                this.we.flushBlockBag(player, redone);
                continue;
            }
            player.printError("Nothing left to redo.");
        }
        session.setMask(mask);
    }

    @Command(aliases={"/clearhistory", "clearhistory"}, usage="", desc="Clear your history", min=0, max=0)
    @CommandPermissions(value={"worldedit.history.clear"})
    public void clearHistory(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.clearHistory();
        player.print("History cleared.");
    }
}

