/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.operation;

import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.operation.FlatRegionFunction;
import com.sk89q.worldedit.operation.Operation;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;

public class FlatRegionApplicator
implements Operation {
    private final FlatRegion flatRegion;
    private final FlatRegionFunction function;
    private int affected = 0;

    public FlatRegionApplicator(Region region, FlatRegionFunction function) {
        this.function = function;
        this.flatRegion = region instanceof FlatRegion ? (FlatRegion)region : CuboidRegion.makeCuboid(region);
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public Operation resume() throws WorldEditException {
        for (Vector2D pt : this.flatRegion.asFlatRegion()) {
            if (!this.function.apply(pt)) continue;
            ++this.affected;
        }
        return null;
    }

    @Override
    public void cancel() {
    }
}

