/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.operation;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.noise.NoiseGenerator;
import com.sk89q.worldedit.noise.RandomNoise;
import com.sk89q.worldedit.operation.GroundFindingFunction;
import com.sk89q.worldedit.operation.RegionFunction;

public class GroundScatterFunction
extends GroundFindingFunction {
    private NoiseGenerator noiseGenerator;
    private RegionFunction function;
    private double density;

    public GroundScatterFunction(EditSession editSession, RegionFunction function) {
        this(editSession, function, new RandomNoise());
    }

    public GroundScatterFunction(EditSession editSession, RegionFunction function, NoiseGenerator noiseGenerator) {
        super(editSession);
        this.function = function;
        this.noiseGenerator = noiseGenerator;
    }

    public double getDensity() {
        return this.density;
    }

    public void setDensity(double density) {
        this.density = density;
    }

    public NoiseGenerator getNoiseGenerator() {
        return this.noiseGenerator;
    }

    public void setNoiseGenerator(NoiseGenerator noiseGenerator) {
        this.noiseGenerator = noiseGenerator;
    }

    public RegionFunction getFunction() {
        return this.function;
    }

    public void setFunction(RegionFunction function) {
        this.function = function;
    }

    @Override
    protected boolean shouldContinue(Vector2D pt) {
        return (double)this.noiseGenerator.noise(pt) <= this.density;
    }

    @Override
    protected boolean apply(Vector position, BaseBlock block) throws WorldEditException {
        return this.function.apply(position);
    }
}

