/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.operation;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.operation.FlatRegionFunction;
import com.sk89q.worldedit.regions.Region;

public abstract class GroundFindingFunction
implements FlatRegionFunction {
    private final EditSession editSession;
    private int lowerY;
    private int upperY;

    protected GroundFindingFunction(EditSession editSession) {
        this.editSession = editSession;
        this.checkYBounds();
    }

    private void checkYBounds() {
        if (this.upperY < this.lowerY) {
            throw new IllegalArgumentException("upperY must be greater than or equal to lowerY");
        }
    }

    public int getUpperY() {
        return this.upperY;
    }

    public int getLowerY() {
        return this.lowerY;
    }

    public void setRange(int lowerY, int upperY) {
        this.lowerY = lowerY;
        this.upperY = upperY;
        this.checkYBounds();
    }

    public void setRange(Region region) {
        this.setRange(region.getMinimumPoint().getBlockY(), region.getMaximumPoint().getBlockY());
    }

    public void raiseCeiling(int y) {
        if (y <= 0) {
            throw new IllegalArgumentException("Can't raise by a negative");
        }
        this.upperY += y;
    }

    @Override
    public final boolean apply(Vector2D pt) throws WorldEditException {
        if (!this.editSession.getBlock(pt.toVector(this.upperY + 1)).isAir()) {
            return false;
        }
        if (!this.shouldContinue(pt)) {
            return false;
        }
        for (int y = this.upperY + 1; y >= this.lowerY; --y) {
            BaseBlock block;
            Vector testPt = pt.toVector(y);
            if (this.shouldPassThrough(testPt, block = this.editSession.getBlock(testPt))) continue;
            return this.apply(testPt, block);
        }
        return false;
    }

    protected boolean shouldContinue(Vector2D pt) {
        return true;
    }

    protected boolean shouldPassThrough(Vector position, BaseBlock block) {
        return block.getType() == 0;
    }

    protected abstract boolean apply(Vector var1, BaseBlock var2) throws WorldEditException;
}

