/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.generator;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.operation.RegionFunction;
import com.sk89q.worldedit.patterns.BlockChance;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.patterns.RandomFillPattern;
import java.util.ArrayList;

public class FloraGenerator
implements RegionFunction {
    private final EditSession editSession;
    private boolean biomeAware = false;
    private final Pattern desertPattern = FloraGenerator.getDesertPattern();
    private final Pattern temperatePattern = FloraGenerator.getTemperatePattern();

    public FloraGenerator(EditSession editSession) {
        this.editSession = editSession;
    }

    public boolean isBiomeAware() {
        return this.biomeAware;
    }

    public void setBiomeAware(boolean biomeAware) {
        if (biomeAware) {
            throw new IllegalArgumentException("Cannot enable biome-aware mode; not yet implemented");
        }
        this.biomeAware = biomeAware;
    }

    public static Pattern getDesertPattern() {
        ArrayList<BlockChance> chance = new ArrayList<BlockChance>();
        chance.add(new BlockChance(new BaseBlock(32), 30.0));
        chance.add(new BlockChance(new BaseBlock(81), 20.0));
        chance.add(new BlockChance(new BaseBlock(0), 300.0));
        return new RandomFillPattern(chance);
    }

    public static Pattern getTemperatePattern() {
        ArrayList<BlockChance> chance = new ArrayList<BlockChance>();
        chance.add(new BlockChance(new BaseBlock(31, 1), 300.0));
        chance.add(new BlockChance(new BaseBlock(38), 5.0));
        chance.add(new BlockChance(new BaseBlock(37), 5.0));
        return new RandomFillPattern(chance);
    }

    @Override
    public boolean apply(Vector position) throws WorldEditException {
        BaseBlock block = this.editSession.getBlock(position);
        if (block.getType() == 2) {
            this.editSession.setBlock(position.add(0, 1, 0), this.temperatePattern.next(position));
            return true;
        }
        if (block.getType() == 12) {
            this.editSession.setBlock(position.add(0, 1, 0), this.desertPattern.next(position));
            return true;
        }
        return false;
    }
}

