/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.filtering.HeightMapFilter;
import com.sk89q.worldedit.regions.Region;

public class HeightMap {
    private int[] data;
    private int width;
    private int height;
    private Region region;
    private EditSession session;

    public HeightMap(EditSession session, Region region) {
        this(session, region, false);
    }

    public HeightMap(EditSession session, Region region, boolean naturalOnly) {
        this.session = session;
        this.region = region;
        this.width = region.getWidth();
        this.height = region.getLength();
        int minX = region.getMinimumPoint().getBlockX();
        int minY = region.getMinimumPoint().getBlockY();
        int minZ = region.getMinimumPoint().getBlockZ();
        int maxY = region.getMaximumPoint().getBlockY();
        this.data = new int[this.width * this.height];
        int z = 0;
        while (z < this.height) {
            int x = 0;
            while (x < this.width) {
                this.data[z * this.width + x] = session.getHighestTerrainBlock(x + minX, z + minZ, minY, maxY, naturalOnly);
                ++x;
            }
            ++z;
        }
    }

    public int applyFilter(HeightMapFilter filter, int iterations) throws MaxChangedBlocksException {
        int[] newData = new int[this.data.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        int i = 0;
        while (i < iterations) {
            newData = filter.filter(newData, this.width, this.height);
            ++i;
        }
        return this.apply(newData);
    }

    public int apply(int[] data) throws MaxChangedBlocksException {
        Vector minY = this.region.getMinimumPoint();
        int originX = minY.getBlockX();
        int originY = minY.getBlockY();
        int originZ = minY.getBlockZ();
        int maxY = this.region.getMaximumPoint().getBlockY();
        BaseBlock fillerAir = new BaseBlock(0);
        int blocksChanged = 0;
        int z = 0;
        while (z < this.height) {
            int x = 0;
            while (x < this.width) {
                int index = z * this.width + x;
                int curHeight = this.data[index];
                int newHeight = Math.min(maxY, data[index]);
                int X = x + originX;
                int Z = z + originZ;
                double scale = (double)(curHeight - originY) / (double)(newHeight - originY);
                if (newHeight > curHeight) {
                    BaseBlock existing = this.session.getBlock(new Vector(X, curHeight, Z));
                    if (existing.getType() != 8 && existing.getType() != 9 && existing.getType() != 10 && existing.getType() != 11) {
                        this.session.setBlock(new Vector(X, newHeight, Z), existing);
                        ++blocksChanged;
                        int y = newHeight - 1 - originY;
                        while (y >= 0) {
                            int copyFrom = (int)((double)y * scale);
                            this.session.setBlock(new Vector(X, originY + y, Z), this.session.getBlock(new Vector(X, originY + copyFrom, Z)));
                            ++blocksChanged;
                            --y;
                        }
                    }
                } else if (curHeight > newHeight) {
                    int y = 0;
                    while (y < newHeight - originY) {
                        int copyFrom = (int)((double)y * scale);
                        this.session.setBlock(new Vector(X, originY + y, Z), this.session.getBlock(new Vector(X, originY + copyFrom, Z)));
                        ++blocksChanged;
                        ++y;
                    }
                    this.session.setBlock(new Vector(X, newHeight, Z), this.session.getBlock(new Vector(X, curHeight, Z)));
                    ++blocksChanged;
                    y = newHeight + 1;
                    while (y <= curHeight) {
                        this.session.setBlock(new Vector(X, y, Z), fillerAir);
                        ++blocksChanged;
                        ++y;
                    }
                }
                ++x;
            }
            ++z;
        }
        return blocksChanged;
    }
}

