/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.expression.runtime;

import com.sk89q.worldedit.expression.Expression;
import com.sk89q.worldedit.expression.parser.ParserException;
import com.sk89q.worldedit.expression.runtime.Break;
import com.sk89q.worldedit.expression.runtime.BreakException;
import com.sk89q.worldedit.expression.runtime.Constant;
import com.sk89q.worldedit.expression.runtime.EvaluationException;
import com.sk89q.worldedit.expression.runtime.Node;
import com.sk89q.worldedit.expression.runtime.RValue;
import com.sk89q.worldedit.expression.runtime.Sequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Switch
extends Node
implements RValue {
    private RValue parameter;
    private final Map<Double, Integer> valueMap;
    private final RValue[] caseStatements;
    private RValue defaultCase;

    public Switch(int position, RValue parameter, List<Double> values, List<RValue> caseStatements, RValue defaultCase) {
        this(position, parameter, Switch.invertList(values), caseStatements, defaultCase);
    }

    private static Map<Double, Integer> invertList(List<Double> values) {
        HashMap<Double, Integer> valueMap = new HashMap<Double, Integer>();
        int i = 0;
        while (i < values.size()) {
            valueMap.put(values.get(i), i);
            ++i;
        }
        return valueMap;
    }

    private Switch(int position, RValue parameter, Map<Double, Integer> valueMap, List<RValue> caseStatements, RValue defaultCase) {
        super(position);
        this.parameter = parameter;
        this.valueMap = valueMap;
        this.caseStatements = caseStatements.toArray(new RValue[caseStatements.size()]);
        this.defaultCase = defaultCase;
    }

    @Override
    public char id() {
        return 'W';
    }

    @Override
    public double getValue() throws EvaluationException {
        double parameter = this.parameter.getValue();
        try {
            double ret = 0.0;
            Integer index = this.valueMap.get(parameter);
            if (index != null) {
                int i = index;
                while (i < this.caseStatements.length) {
                    ret = this.caseStatements[i].getValue();
                    ++i;
                }
            }
            return this.defaultCase == null ? ret : this.defaultCase.getValue();
        }
        catch (BreakException e) {
            if (e.doContinue) {
                throw e;
            }
            return 0.0;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("switch (");
        sb.append(this.parameter);
        sb.append(") { ");
        int i = 0;
        while (i < this.caseStatements.length) {
            RValue caseStatement = this.caseStatements[i];
            sb.append("case ");
            for (Map.Entry<Double, Integer> entry : this.valueMap.entrySet()) {
                if (entry.getValue() != i) continue;
                sb.append(entry.getKey());
                break;
            }
            sb.append(": ");
            sb.append(caseStatement);
            sb.append(' ');
            ++i;
        }
        if (this.defaultCase != null) {
            sb.append("default: ");
            sb.append(this.defaultCase);
            sb.append(' ');
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public RValue optimize() throws EvaluationException {
        RValue optimizedParameter = this.parameter.optimize();
        ArrayList<RValue> newSequence = new ArrayList<RValue>();
        if (optimizedParameter instanceof Constant) {
            double parameter = optimizedParameter.getValue();
            Integer index = this.valueMap.get(parameter);
            if (index == null) {
                return this.defaultCase == null ? new Constant(this.getPosition(), 0.0) : this.defaultCase.optimize();
            }
            boolean breakDetected = false;
            int i = index;
            while (i < this.caseStatements.length && !breakDetected) {
                RValue invokable = this.caseStatements[i].optimize();
                if (invokable instanceof Sequence) {
                    RValue[] rValueArray = ((Sequence)invokable).sequence;
                    int n = ((Sequence)invokable).sequence.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RValue subInvokable = rValueArray[n2];
                        if (subInvokable instanceof Break) {
                            breakDetected = true;
                            break;
                        }
                        newSequence.add(subInvokable);
                        ++n2;
                    }
                } else {
                    newSequence.add(invokable);
                }
                ++i;
            }
            if (this.defaultCase != null && !breakDetected) {
                RValue invokable = this.defaultCase.optimize();
                if (invokable instanceof Sequence) {
                    Collections.addAll(newSequence, ((Sequence)invokable).sequence);
                } else {
                    newSequence.add(invokable);
                }
            }
            return new Switch(this.getPosition(), optimizedParameter, Collections.singletonMap(parameter, 0), newSequence, null);
        }
        HashMap<Double, Integer> newValueMap = new HashMap<Double, Integer>();
        HashMap<Integer, Double> backMap = new HashMap<Integer, Double>();
        for (Map.Entry<Double, Integer> entry : this.valueMap.entrySet()) {
            backMap.put(entry.getValue(), entry.getKey());
        }
        int i = 0;
        while (i < this.caseStatements.length) {
            RValue invokable = this.caseStatements[i].optimize();
            Double caseValue = (Double)backMap.get(i);
            if (caseValue != null) {
                newValueMap.put(caseValue, newSequence.size());
            }
            if (invokable instanceof Sequence) {
                RValue[] rValueArray = ((Sequence)invokable).sequence;
                int n = ((Sequence)invokable).sequence.length;
                int n3 = 0;
                while (n3 < n) {
                    RValue subInvokable = rValueArray[n3];
                    newSequence.add(subInvokable);
                    ++n3;
                }
            } else {
                newSequence.add(invokable);
            }
            ++i;
        }
        return new Switch(this.getPosition(), optimizedParameter, newValueMap, newSequence, this.defaultCase.optimize());
    }

    @Override
    public RValue bindVariables(Expression expression, boolean preferLValue) throws ParserException {
        this.parameter = this.parameter.bindVariables(expression, false);
        int i = 0;
        while (i < this.caseStatements.length) {
            this.caseStatements[i] = this.caseStatements[i].bindVariables(expression, false);
            ++i;
        }
        this.defaultCase = this.defaultCase.bindVariables(expression, false);
        return this;
    }
}

