/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.filtering;

import java.awt.image.Kernel;

public class HeightMapFilter {
    private Kernel kernel;

    public HeightMapFilter(Kernel kernel) {
        this.kernel = kernel;
    }

    public HeightMapFilter(int kernelWidth, int kernelHeight, float[] kernelData) {
        this.kernel = new Kernel(kernelWidth, kernelHeight, kernelData);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public int[] filter(int[] inData, int width, int height) {
        int index = 0;
        float[] matrix = this.kernel.getKernelData(null);
        int[] outData = new int[inData.length];
        int kh = this.kernel.getHeight();
        int kw = this.kernel.getWidth();
        int kox = this.kernel.getXOrigin();
        int koy = this.kernel.getYOrigin();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                float z = 0.0f;
                int ky = 0;
                while (ky < kh) {
                    int offsetY = y + ky - koy;
                    if (offsetY < 0 || offsetY >= height) {
                        offsetY = y;
                    }
                    offsetY *= width;
                    int matrixOffset = ky * kw;
                    int kx = 0;
                    while (kx < kw) {
                        float f = matrix[matrixOffset + kx];
                        if (f != 0.0f) {
                            int offsetX = x + kx - kox;
                            if (offsetX < 0 || offsetX >= width) {
                                offsetX = x;
                            }
                            z += f * (float)inData[offsetY + offsetX];
                        }
                        ++kx;
                    }
                    ++ky;
                }
                outData[index++] = (int)((double)z + 0.5);
                ++x;
            }
            ++y;
        }
        return outData;
    }
}

