/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.tools;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.tools.BlockTool;

public class AreaPickaxe
implements BlockTool {
    private static final BaseBlock air = new BaseBlock(0);
    private int range;

    public AreaPickaxe(int range) {
        this.range = range;
    }

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.superpickaxe.area");
    }

    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        LocalWorld world = clicked.getWorld();
        int ox = clicked.getBlockX();
        int oy = clicked.getBlockY();
        int oz = clicked.getBlockZ();
        int initialType = world.getBlockType(clicked);
        if (initialType == 0) {
            return true;
        }
        if (initialType == 7 && !player.canDestroyBedrock()) {
            return true;
        }
        EditSession editSession = session.createEditSession(player);
        try {
            try {
                int x = ox - this.range;
                while (x <= ox + this.range) {
                    int y = oy - this.range;
                    while (y <= oy + this.range) {
                        int z = oz - this.range;
                        while (z <= oz + this.range) {
                            Vector pos = new Vector(x, y, z);
                            if (world.getBlockType(pos) == initialType) {
                                if (config.superPickaxeManyDrop) {
                                    world.simulateBlockMine(pos);
                                }
                                world.queueBlockBreakEffect(server, pos, initialType, clicked.distanceSq(pos));
                                editSession.setBlock(pos, air);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            catch (MaxChangedBlocksException e) {
                player.printError("Max blocks change limit reached.");
                session.remember(editSession);
            }
        }
        finally {
            session.remember(editSession);
        }
        return true;
    }
}

