/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.tools;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.tools.BlockTool;
import com.sk89q.worldedit.util.TreeGenerator;

public class TreePlanter
implements BlockTool {
    private TreeGenerator gen;

    public TreePlanter(TreeGenerator gen) {
        this.gen = gen;
    }

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.tool.tree");
    }

    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        EditSession editSession = session.createEditSession(player);
        try {
            try {
                boolean successful = false;
                int i = 0;
                while (i < 10) {
                    if (this.gen.generate(editSession, clicked.add(0, 1, 0))) {
                        successful = true;
                        break;
                    }
                    ++i;
                }
                if (!successful) {
                    player.printError("A tree can't go there.");
                }
            }
            catch (MaxChangedBlocksException e) {
                player.printError("Max. blocks changed reached.");
                session.remember(editSession);
            }
        }
        finally {
            session.remember(editSession);
        }
        return true;
    }
}

