/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.registry.WorldData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SchematicWriter
implements ClipboardWriter {
    private static final int MAX_SIZE = 65535;
    private final NBTOutputStream outputStream;

    public SchematicWriter(NBTOutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream);
        this.outputStream = outputStream;
    }

    @Override
    public void write(Clipboard clipboard, WorldData data) throws IOException {
        Region region = clipboard.getRegion();
        Vector origin = clipboard.getOrigin();
        Vector min = region.getMinimumPoint();
        Vector offset = min.subtract(origin);
        int width = region.getWidth();
        int height = region.getHeight();
        int length = region.getLength();
        if (width > 65535) {
            throw new IllegalArgumentException("Width of region too large for a .schematic");
        }
        if (height > 65535) {
            throw new IllegalArgumentException("Height of region too large for a .schematic");
        }
        if (length > 65535) {
            throw new IllegalArgumentException("Length of region too large for a .schematic");
        }
        HashMap<String, Tag> schematic = new HashMap<String, Tag>();
        schematic.put("Width", new ShortTag("Width", (short)width));
        schematic.put("Length", new ShortTag("Length", (short)length));
        schematic.put("Height", new ShortTag("Height", (short)height));
        schematic.put("Materials", new StringTag("Materials", "Alpha"));
        schematic.put("WEOriginX", new IntTag("WEOriginX", min.getBlockX()));
        schematic.put("WEOriginY", new IntTag("WEOriginY", min.getBlockY()));
        schematic.put("WEOriginZ", new IntTag("WEOriginZ", min.getBlockZ()));
        schematic.put("WEOffsetX", new IntTag("WEOffsetX", offset.getBlockX()));
        schematic.put("WEOffsetY", new IntTag("WEOffsetY", offset.getBlockY()));
        schematic.put("WEOffsetZ", new IntTag("WEOffsetZ", offset.getBlockZ()));
        byte[] blocks = new byte[width * height * length];
        byte[] addBlocks = null;
        byte[] blockData = new byte[width * height * length];
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        for (Vector point : region) {
            Vector vector = point.subtract(min);
            int x = vector.getBlockX();
            int y = vector.getBlockY();
            int z = vector.getBlockZ();
            int index = y * width * length + z * width + x;
            BaseBlock block = clipboard.getBlock(point);
            if (block.getType() > 255) {
                if (addBlocks == null) {
                    addBlocks = new byte[(blocks.length >> 1) + 1];
                }
                addBlocks[index >> 1] = (byte)((index & 1) == 0 ? addBlocks[index >> 1] & 0xF0 | block.getType() >> 8 & 0xF : addBlocks[index >> 1] & 0xF | (block.getType() >> 8 & 0xF) << 4);
            }
            blocks[index] = (byte)block.getType();
            blockData[index] = (byte)block.getData();
            CompoundTag rawTag = block.getNbtData();
            if (rawTag == null) continue;
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            for (Map.Entry entry : rawTag.getValue().entrySet()) {
                values.put((String)entry.getKey(), (Tag)entry.getValue());
            }
            values.put("id", new StringTag("id", block.getNbtId()));
            values.put("x", new IntTag("x", x));
            values.put("y", new IntTag("y", y));
            values.put("z", new IntTag("z", z));
            CompoundTag tileEntityTag = new CompoundTag("TileEntity", values);
            tileEntities.add(tileEntityTag);
        }
        schematic.put("Blocks", new ByteArrayTag("Blocks", blocks));
        schematic.put("Data", new ByteArrayTag("Data", blockData));
        schematic.put("TileEntities", new ListTag("TileEntities", CompoundTag.class, tileEntities));
        if (addBlocks != null) {
            schematic.put("AddBlocks", new ByteArrayTag("AddBlocks", addBlocks));
        }
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (Entity entity : clipboard.getEntities()) {
            BaseEntity state = entity.getState();
            if (state == null) continue;
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            CompoundTag rawTag = state.getNbtData();
            if (rawTag != null) {
                values.putAll((Map<String, Tag>)rawTag.getValue());
            }
            values.put("id", new StringTag("id", state.getTypeId()));
            values.put("Pos", this.writeVector(entity.getLocation().toVector(), "Pos"));
            values.put("Rotation", this.writeRotation(entity.getLocation(), "Rotation"));
            CompoundTag entityTag = new CompoundTag("Entity", values);
            entities.add(entityTag);
        }
        schematic.put("Entities", new ListTag("Entities", CompoundTag.class, entities));
        CompoundTag schematicTag = new CompoundTag("Schematic", schematic);
        this.outputStream.writeTag(schematicTag);
    }

    private Tag writeVector(Vector vector, String name) {
        ArrayList<DoubleTag> list = new ArrayList<DoubleTag>();
        list.add(new DoubleTag("", vector.getX()));
        list.add(new DoubleTag("", vector.getY()));
        list.add(new DoubleTag("", vector.getZ()));
        return new ListTag(name, DoubleTag.class, list);
    }

    private Tag writeRotation(Location location, String name) {
        ArrayList<FloatTag> list = new ArrayList<FloatTag>();
        list.add(new FloatTag("", location.getYaw()));
        list.add(new FloatTag("", location.getPitch()));
        return new ListTag(name, FloatTag.class, list);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

