/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.entity;

import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.entity.BukkitEntity;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Painting;

public class BukkitPainting
extends BukkitEntity {
    private static final Logger log = Logger.getLogger(BukkitPainting.class.getCanonicalName());
    private static int spawnTask = -1;
    private static final Deque<QueuedPaintingSpawn> spawnQueue = new ArrayDeque<QueuedPaintingSpawn>();
    private final Art art;
    private final BlockFace facingDirection;

    public BukkitPainting(Location loc, Art art, BlockFace facingDirection, UUID entityId) {
        super(loc, EntityType.PAINTING, entityId);
        this.art = art;
        this.facingDirection = facingDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean spawn(Location weLoc) {
        Deque<QueuedPaintingSpawn> deque = spawnQueue;
        synchronized (deque) {
            spawnQueue.add(new QueuedPaintingSpawn(weLoc));
            if (spawnTask == -1) {
                spawnTask = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(Bukkit.getServer().getPluginManager().getPlugin("WorldEdit"), (Runnable)new PaintingSpawnRunnable(), 1L);
            }
        }
        return true;
    }

    public boolean spawnRaw(Location weLoc) {
        org.bukkit.Location loc = BukkitUtil.toLocation(weLoc);
        Painting paint = (Painting)loc.getWorld().spawn(loc, Painting.class);
        if (paint != null) {
            paint.setFacingDirection(this.facingDirection, true);
            paint.setArt(this.art, true);
            return true;
        }
        return false;
    }

    private static class PaintingSpawnRunnable
    implements Runnable {
        private PaintingSpawnRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Deque deque = spawnQueue;
            synchronized (deque) {
                QueuedPaintingSpawn spawn;
                while ((spawn = (QueuedPaintingSpawn)spawnQueue.poll()) != null) {
                    try {
                        spawn.spawn();
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Failed to spawn painting", t);
                    }
                }
                spawnTask = -1;
            }
        }
    }

    private class QueuedPaintingSpawn {
        private final Location weLoc;

        private QueuedPaintingSpawn(Location weLoc) {
            this.weLoc = weLoc;
        }

        public void spawn() {
            BukkitPainting.this.spawnRaw(this.weLoc);
        }
    }
}

