/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.operation;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import java.util.Iterator;
import java.util.Map;

public class BlockMapEntryPlacer
implements Operation {
    private final Extent extent;
    private final Iterator<Map.Entry<BlockVector, BaseBlock>> iterator;

    public BlockMapEntryPlacer(Extent extent, Iterator<Map.Entry<BlockVector, BaseBlock>> iterator) {
        Preconditions.checkNotNull((Object)extent);
        Preconditions.checkNotNull(iterator);
        this.extent = extent;
        this.iterator = iterator;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        while (this.iterator.hasNext()) {
            Map.Entry<BlockVector, BaseBlock> entry = this.iterator.next();
            this.extent.setBlock(entry.getKey(), entry.getValue());
        }
        return null;
    }

    @Override
    public void cancel() {
    }
}

