/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.brush.ButcherBrush;
import com.sk89q.worldedit.command.tool.brush.ClipboardBrush;
import com.sk89q.worldedit.command.tool.brush.CylinderBrush;
import com.sk89q.worldedit.command.tool.brush.GravityBrush;
import com.sk89q.worldedit.command.tool.brush.HollowCylinderBrush;
import com.sk89q.worldedit.command.tool.brush.HollowSphereBrush;
import com.sk89q.worldedit.command.tool.brush.SmoothBrush;
import com.sk89q.worldedit.command.tool.brush.SphereBrush;
import com.sk89q.worldedit.command.util.CreatureButcher;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.BlockMask;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.util.command.parametric.Optional;

public class BrushCommands {
    private final WorldEdit worldEdit;

    public BrushCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(aliases={"sphere", "s"}, usage="<pattern> [radius]", flags="h", desc="Choose the sphere brush", help="Chooses the sphere brush.\nThe -h flag creates hollow spheres instead.", min=1, max=2)
    @CommandPermissions(value={"worldedit.brush.sphere"})
    public void sphereBrush(Player player, LocalSession session, EditSession editSession, Pattern fill, @Optional(value={"2"}) double radius, @Switch(value=104) boolean hollow) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setFill(fill);
        tool.setSize(radius);
        if (hollow) {
            tool.setBrush(new HollowSphereBrush(), "worldedit.brush.sphere");
        } else {
            tool.setBrush(new SphereBrush(), "worldedit.brush.sphere");
        }
        player.print(String.format("Sphere brush shape equipped (%.0f).", radius));
    }

    @Command(aliases={"cylinder", "cyl", "c"}, usage="<block> [radius] [height]", flags="h", desc="Choose the cylinder brush", help="Chooses the cylinder brush.\nThe -h flag creates hollow cylinders instead.", min=1, max=3)
    @CommandPermissions(value={"worldedit.brush.cylinder"})
    public void cylinderBrush(Player player, LocalSession session, EditSession editSession, Pattern fill, @Optional(value={"2"}) double radius, @Optional(value={"1"}) int height, @Switch(value=104) boolean hollow) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        this.worldEdit.checkMaxBrushRadius(height);
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setFill(fill);
        tool.setSize(radius);
        if (hollow) {
            tool.setBrush(new HollowCylinderBrush(height), "worldedit.brush.cylinder");
        } else {
            tool.setBrush(new CylinderBrush(height), "worldedit.brush.cylinder");
        }
        player.print(String.format("Cylinder brush shape equipped (%.0f by %d).", radius, height));
    }

    @Command(aliases={"clipboard", "copy"}, usage="", desc="Choose the clipboard brush", help="Chooses the clipboard brush.\nThe -a flag makes it not paste air.\nWithout the -p flag, the paste will appear centered at the target location. With the flag, then the paste will appear relative to where you had stood relative to the copied area when you copied it.")
    @CommandPermissions(value={"worldedit.brush.clipboard"})
    public void clipboardBrush(Player player, LocalSession session, EditSession editSession, @Switch(value=97) boolean ignoreAir, @Switch(value=112) boolean usingOrigin) throws WorldEditException {
        ClipboardHolder holder = session.getClipboard();
        Clipboard clipboard = holder.getClipboard();
        Vector size = clipboard.getDimensions();
        this.worldEdit.checkMaxBrushRadius(size.getBlockX());
        this.worldEdit.checkMaxBrushRadius(size.getBlockY());
        this.worldEdit.checkMaxBrushRadius(size.getBlockZ());
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setBrush(new ClipboardBrush(holder, ignoreAir, usingOrigin), "worldedit.brush.clipboard");
        player.print("Clipboard brush shape equipped.");
    }

    @Command(aliases={"smooth"}, usage="[size] [iterations]", flags="n", desc="Choose the terrain softener brush", help="Chooses the terrain softener brush.\nThe -n flag makes it only consider naturally occurring blocks.", min=0, max=2)
    @CommandPermissions(value={"worldedit.brush.smooth"})
    public void smoothBrush(Player player, LocalSession session, EditSession editSession, @Optional(value={"2"}) double radius, @Optional(value={"4"}) int iterations, @Switch(value=110) boolean naturalBlocksOnly) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setSize(radius);
        tool.setBrush(new SmoothBrush(iterations, naturalBlocksOnly), "worldedit.brush.smooth");
        player.print(String.format("Smooth brush equipped (%.0f x %dx, using " + (naturalBlocksOnly ? "natural blocks only" : "any block") + ").", radius, iterations));
    }

    @Command(aliases={"ex", "extinguish"}, usage="[radius]", desc="Shortcut fire extinguisher brush", min=0, max=1)
    @CommandPermissions(value={"worldedit.brush.ex"})
    public void extinguishBrush(Player player, LocalSession session, EditSession editSession, @Optional(value={"5"}) double radius) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        BlockPattern fill = new BlockPattern(new BaseBlock(0));
        tool.setFill(fill);
        tool.setSize(radius);
        tool.setMask(new BlockMask((Extent)editSession, new BaseBlock(51)));
        tool.setBrush(new SphereBrush(), "worldedit.brush.ex");
        player.print(String.format("Extinguisher equipped (%.0f).", radius));
    }

    @Command(aliases={"gravity", "grav"}, usage="[radius]", flags="h", desc="Gravity brush", help="This brush simulates the affect of gravity.\nThe -h flag makes it affect blocks starting at the world's max y, instead of the clicked block's y + radius.", min=0, max=1)
    @CommandPermissions(value={"worldedit.brush.gravity"})
    public void gravityBrush(Player player, LocalSession session, EditSession editSession, @Optional(value={"5"}) double radius, @Switch(value=104) boolean fromMaxY) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setSize(radius);
        tool.setBrush(new GravityBrush(fromMaxY), "worldedit.brush.gravity");
        player.print(String.format("Gravity brush equipped (%.0f).", radius));
    }

    @Command(aliases={"butcher", "kill"}, usage="[radius]", flags="plangbtf", desc="Butcher brush", help="Kills nearby mobs within the specified radius.\nFlags:  -p also kills pets.\n  -n also kills NPCs.\n  -g also kills Golems.\n  -a also kills animals.\n  -b also kills ambient mobs.\n  -t also kills mobs with name tags.\n  -f compounds all previous flags.\n  -l currently does nothing.", min=0, max=1)
    @CommandPermissions(value={"worldedit.brush.butcher"})
    public void butcherBrush(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        double radius = args.argsLength() > 0 ? args.getDouble(0) : 5.0;
        double maxRadius = config.maxBrushRadius;
        if (player.hasPermission("worldedit.butcher")) {
            maxRadius = Math.max(config.maxBrushRadius, config.butcherMaxRadius);
        }
        if (radius > maxRadius) {
            player.printError("Maximum allowed brush radius: " + maxRadius);
            return;
        }
        CreatureButcher flags = new CreatureButcher(player);
        flags.fromCommand(args);
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setSize(radius);
        tool.setBrush(new ButcherBrush(flags), "worldedit.brush.butcher");
        player.print(String.format("Butcher brush equipped (%.0f).", radius));
    }
}

