/*
 * WorldEdit, a Minecraft world manipulation toolkit
 * Copyright (C) sk89q <http://www.sk89q.com>
 * Copyright (C) WorldEdit team and contributors
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.sk89q.worldedit.blocks;

/**
 * List of item IDs.
 */
public final class ItemID {

    public static final int IRON_SHOVEL = 256;
    public static final int IRON_PICK = 257;
    public static final int IRON_AXE = 258;
    public static final int FLINT_AND_TINDER = 259;
    public static final int RED_APPLE = 260;
    public static final int BOW = 261;
    public static final int ARROW = 262;
    public static final int COAL = 263;
    public static final int DIAMOND = 264;
    public static final int IRON_BAR = 265;
    public static final int GOLD_BAR = 266;
    public static final int IRON_SWORD = 267;
    public static final int WOOD_SWORD = 268;
    public static final int WOOD_SHOVEL = 269;
    public static final int WOOD_PICKAXE = 270;
    public static final int WOOD_AXE = 271;
    public static final int STONE_SWORD = 272;
    public static final int STONE_SHOVEL = 273;
    public static final int STONE_PICKAXE = 274;
    public static final int STONE_AXE = 275;
    public static final int DIAMOND_SWORD = 276;
    public static final int DIAMOND_SHOVEL = 277;
    public static final int DIAMOND_PICKAXE = 278;
    public static final int DIAMOND_AXE = 279;
    public static final int STICK = 280;
    public static final int BOWL = 281;
    public static final int MUSHROOM_SOUP = 282;
    public static final int GOLD_SWORD = 283;
    public static final int GOLD_SHOVEL = 284;
    public static final int GOLD_PICKAXE = 285;
    public static final int GOLD_AXE = 286;
    public static final int STRING = 287;
    public static final int FEATHER = 288;
    public static final int SULPHUR = 289;
    public static final int WOOD_HOE = 290;
    public static final int STONE_HOE = 291;
    public static final int IRON_HOE = 292;
    public static final int DIAMOND_HOE = 293;
    public static final int GOLD_HOE = 294;
    public static final int SEEDS = 295;
    public static final int WHEAT = 296;
    public static final int BREAD = 297;
    public static final int LEATHER_HELMET = 298;
    public static final int LEATHER_CHEST = 299;
    public static final int LEATHER_PANTS = 300;
    public static final int LEATHER_BOOTS = 301;
    public static final int CHAINMAIL_HELMET = 302;
    public static final int CHAINMAIL_CHEST = 303;
    public static final int CHAINMAIL_PANTS = 304;
    public static final int CHAINMAIL_BOOTS = 305;
    public static final int IRON_HELMET = 306;
    public static final int IRON_CHEST = 307;
    public static final int IRON_PANTS = 308;
    public static final int IRON_BOOTS = 309;
    public static final int DIAMOND_HELMET = 310;
    public static final int DIAMOND_CHEST = 311;
    public static final int DIAMOND_PANTS = 312;
    public static final int DIAMOND_BOOTS = 313;
    public static final int GOLD_HELMET = 314;
    public static final int GOLD_CHEST = 315;
    public static final int GOLD_PANTS = 316;
    public static final int GOLD_BOOTS = 317;
    public static final int FLINT = 318;
    public static final int RAW_PORKCHOP = 319;
    public static final int COOKED_PORKCHOP = 320;
    public static final int PAINTING = 321;
    public static final int GOLD_APPLE = 322;
    public static final int SIGN = 323;
    public static final int WOODEN_DOOR_ITEM = 324;
    public static final int BUCKET = 325;
    public static final int WATER_BUCKET = 326;
    public static final int LAVA_BUCKET = 327;
    public static final int MINECART = 328;
    public static final int SADDLE = 329;
    public static final int IRON_DOOR_ITEM = 330;
    public static final int REDSTONE_DUST = 331;
    public static final int SNOWBALL = 332;
    public static final int WOOD_BOAT = 333;
    public static final int LEATHER = 334;
    public static final int MILK_BUCKET = 335;
    public static final int BRICK_BAR = 336;
    public static final int CLAY_BALL = 337;
    public static final int SUGAR_CANE_ITEM = 338;
    public static final int PAPER = 339;
    public static final int BOOK = 340;
    public static final int SLIME_BALL = 341;
    public static final int STORAGE_MINECART = 342;
    public static final int POWERED_MINECART = 343;
    public static final int EGG = 344;
    public static final int COMPASS = 345;
    public static final int FISHING_ROD = 346;
    public static final int WATCH = 347;
    public static final int LIGHTSTONE_DUST = 348;
    public static final int RAW_FISH = 349;
    public static final int COOKED_FISH = 350;
    public static final int INK_SACK = 351;
    public static final int BONE = 352;
    public static final int SUGAR = 353;
    public static final int CAKE_ITEM = 354;
    public static final int BED_ITEM = 355;
    public static final int REDSTONE_REPEATER = 356;
    public static final int COOKIE = 357;
    public static final int MAP = 358;
    public static final int SHEARS = 359;
    public static final int MELON = 360;
    public static final int PUMPKIN_SEEDS = 361;
    public static final int MELON_SEEDS = 362;
    public static final int RAW_BEEF = 363;
    public static final int COOKED_BEEF = 364;
    public static final int RAW_CHICKEN = 365;
    public static final int COOKED_CHICKEN = 366;
    public static final int ROTTEN_FLESH = 367;
    public static final int ENDER_PEARL = 368;
    public static final int BLAZE_ROD = 369;
    public static final int GHAST_TEAR = 370;
    public static final int GOLD_NUGGET = 371;
    public static final int NETHER_WART_SEED = 372;
    public static final int POTION = 373;
    public static final int GLASS_BOTTLE = 374;
    public static final int SPIDER_EYE = 375;
    public static final int FERMENTED_SPIDER_EYE = 376;
    public static final int BLAZE_POWDER = 377;
    public static final int MAGMA_CREAM = 378;
    public static final int BREWING_STAND = 379;
    public static final int CAULDRON = 380;
    public static final int EYE_OF_ENDER = 381;
    public static final int GLISTERING_MELON = 382;
    public static final int SPAWN_EGG = 383;
    public static final int BOTTLE_O_ENCHANTING = 384;
    public static final int FIRE_CHARGE = 385;
    public static final int BOOK_AND_QUILL = 386;
    public static final int WRITTEN_BOOK = 387;
    public static final int EMERALD = 388;
    public static final int ITEM_FRAME = 389;
    public static final int FLOWER_POT = 390;
    public static final int CARROT = 391;
    public static final int POTATO = 392;
    public static final int BAKED_POTATO = 393;
    public static final int POISONOUS_POTATO = 394;
    public static final int BLANK_MAP = 395;
    public static final int GOLDEN_CARROT = 396;
    public static final int HEAD = 397;
    public static final int CARROT_ON_A_STICK = 398;
    public static final int NETHER_STAR = 399;
    public static final int PUMPKIN_PIE = 400;
    public static final int FIREWORK_ROCKET = 401;
    public static final int FIREWORK_STAR = 402;
    public static final int ENCHANTED_BOOK = 403;
    public static final int COMPARATOR = 404;
    public static final int NETHER_BRICK = 405;
    public static final int NETHER_QUARTZ = 406;
    public static final int TNT_MINECART = 407;
    public static final int HOPPER_MINECART = 408;
    public static final int HORSE_ARMOR_IRON = 417;
    public static final int HORSE_ARMOR_GOLD = 418;
    public static final int HORSE_ARMOR_DIAMOND = 419;
    public static final int LEAD = 420;
    public static final int NAME_TAG = 421;
    public static final int COMMAND_BLOCK_MINECART = 422;

    @Deprecated public static final int GOLD_RECORD = 2256; // deprecated, but leave it there
    @Deprecated public static final int GREEN_RECORD = 2257; // deprecated, but leave it there
    public static final int DISC_13 = 2256;
    public static final int DISC_CAT = 2257;
    public static final int DISC_BLOCKS = 2258;
    public static final int DISC_CHIRP = 2259;
    public static final int DISC_FAR = 2260;
    public static final int DISC_MALL = 2261;
    public static final int DISC_MELLOHI = 2262;
    public static final int DISC_STAL = 2263;
    public static final int DISC_STRAD = 2264;
    public static final int DISC_WARD = 2265;
    public static final int DISC_11 = 2266;
    public static final int DISC_WAIT = 2267;

    private ItemID() {
    }

}
