/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.internal.LocalWorldAdapter;
import com.sk89q.worldedit.world.World;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class WorldEditListener
implements Listener {
    private WorldEditPlugin plugin;
    private boolean ignoreLeftClickAir = false;

    public WorldEditListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        this.plugin.getWorldEdit().markExpire(this.plugin.wrapPlayer(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGamemode(PlayerGameModeChangeEvent event) {
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        WorldEdit.getInstance().getSession(this.plugin.wrapPlayer(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String newMessage;
        String[] split = event.getMessage().split(" ");
        if (split.length > 0) {
            split[0] = split[0].substring(1);
            split = this.plugin.getWorldEdit().getPlatformManager().getCommandManager().commandDetection(split);
        }
        if (!(newMessage = "/" + StringUtil.joinString(split, " ")).equals(event.getMessage())) {
            event.setMessage(newMessage);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (!event.getMessage().isEmpty()) {
                    this.plugin.getServer().dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1));
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        World world = player.getWorld();
        WorldEdit we = this.plugin.getWorldEdit();
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_BLOCK) {
            int taskId;
            Block clickedBlock = event.getClickedBlock();
            WorldVector pos = new WorldVector((LocalWorld)LocalWorldAdapter.adapt(world), clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
            if (we.handleBlockLeftClick(player, pos)) {
                event.setCancelled(true);
            }
            if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
            if (!this.ignoreLeftClickAir && (taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    WorldEditListener.this.ignoreLeftClickAir = false;
                }
            }, 2L)) != -1) {
                this.ignoreLeftClickAir = true;
            }
        } else if (action == Action.LEFT_CLICK_AIR) {
            if (this.ignoreLeftClickAir) {
                return;
            }
            if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            WorldVector pos = new WorldVector((LocalWorld)LocalWorldAdapter.adapt(world), clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
            if (we.handleBlockRightClick(player, pos)) {
                event.setCancelled(true);
            }
            if (we.handleRightClick(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_AIR && we.handleRightClick(player)) {
            event.setCancelled(true);
        }
    }
}

