/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math.interpolation;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.math.interpolation.Interpolation;
import com.sk89q.worldedit.math.interpolation.Node;
import java.util.List;

public class LinearInterpolation
implements Interpolation {
    private List<Node> nodes;

    @Override
    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    @Override
    public Vector getPosition(double position) {
        if (this.nodes == null) {
            throw new IllegalStateException("Must call setNodes first.");
        }
        if (position > 1.0) {
            return null;
        }
        int index1 = (int)Math.floor(position *= (double)(this.nodes.size() - 1));
        double remainder = position - (double)index1;
        Vector position1 = this.nodes.get(index1).getPosition();
        Vector position2 = this.nodes.get(index1 + 1).getPosition();
        return position1.multiply(1.0 - remainder).add(position2.multiply(remainder));
    }

    @Override
    public Vector get1stDerivative(double position) {
        if (this.nodes == null) {
            throw new IllegalStateException("Must call setNodes first.");
        }
        if (position > 1.0) {
            return null;
        }
        int index1 = (int)Math.floor(position *= (double)(this.nodes.size() - 1));
        Vector position1 = this.nodes.get(index1).getPosition();
        Vector position2 = this.nodes.get(index1 + 1).getPosition();
        return position2.subtract(position1);
    }

    @Override
    public double arcLength(double positionA, double positionB) {
        if (this.nodes == null) {
            throw new IllegalStateException("Must call setNodes first.");
        }
        if (positionA > positionB) {
            return this.arcLength(positionB, positionA);
        }
        int indexA = (int)Math.floor(positionA *= (double)(this.nodes.size() - 1));
        double remainderA = positionA - (double)indexA;
        int indexB = (int)Math.floor(positionB *= (double)(this.nodes.size() - 1));
        double remainderB = positionB - (double)indexB;
        return this.arcLengthRecursive(indexA, remainderA, indexB, remainderB);
    }

    private double arcLengthRecursive(int indexA, double remainderA, int indexB, double remainderB) {
        switch (indexB - indexA) {
            case 0: {
                return this.arcLengthRecursive(indexA, remainderA, remainderB);
            }
            case 1: {
                return this.arcLengthRecursive(indexA, remainderA, 1.0) + this.arcLengthRecursive(indexB, 0.0, remainderB);
            }
        }
        return this.arcLengthRecursive(indexA, remainderA, indexB - 1, 1.0) + this.arcLengthRecursive(indexB, 0.0, remainderB);
    }

    private double arcLengthRecursive(int index, double remainderA, double remainderB) {
        Vector position1 = this.nodes.get(index).getPosition();
        Vector position2 = this.nodes.get(index + 1).getPosition();
        return position1.distance(position2) * (remainderB - remainderA);
    }

    @Override
    public int getSegment(double position) {
        if (this.nodes == null) {
            throw new IllegalStateException("Must call setNodes first.");
        }
        if (position > 1.0) {
            return Integer.MAX_VALUE;
        }
        int index = (int)Math.floor(position *= (double)(this.nodes.size() - 1));
        return index;
    }
}

