/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.selector;

import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.EllipsoidRegionSelector;
import com.sk89q.worldedit.world.World;
import javax.annotation.Nullable;

public class SphereRegionSelector
extends EllipsoidRegionSelector {
    @Deprecated
    public SphereRegionSelector(@Nullable LocalWorld world) {
        this((World)world);
    }

    public SphereRegionSelector(@Nullable World world) {
        super(world);
    }

    public SphereRegionSelector() {
    }

    public SphereRegionSelector(RegionSelector oldSelector) {
        super(oldSelector);
        Vector radius = this.region.getRadius();
        double radiusScalar = Math.max(Math.max(radius.getX(), radius.getY()), radius.getZ());
        this.region.setRadius(new Vector(radiusScalar, radiusScalar, radiusScalar));
    }

    public SphereRegionSelector(@Nullable LocalWorld world, Vector center, int radius) {
        super(world, center, new Vector(radius, radius, radius));
    }

    @Override
    public boolean selectSecondary(Vector pos) {
        if (!this.started) {
            return false;
        }
        double radiusScalar = Math.ceil(pos.distance(this.region.getCenter()));
        this.region.setRadius(new Vector(radiusScalar, radiusScalar, radiusScalar));
        return true;
    }

    @Override
    public void explainSecondarySelection(Actor player, LocalSession session, Vector pos) {
        if (this.isDefined()) {
            player.print("Radius set to " + this.region.getRadius().getX() + " (" + this.region.getArea() + ").");
        } else {
            player.print("Radius set to " + this.region.getRadius().getX() + ".");
        }
        session.describeCUI(player);
    }

    @Override
    public String getTypeName() {
        return "sphere";
    }

    @Override
    public void explainPrimarySelection(LocalPlayer player, LocalSession session, Vector position) {
        this.explainPrimarySelection((Actor)player, session, position);
    }

    @Override
    public void explainSecondarySelection(LocalPlayer player, LocalSession session, Vector position) {
        this.explainSecondarySelection((Actor)player, session, position);
    }

    @Override
    public void explainRegionAdjust(LocalPlayer player, LocalSession session) {
        this.explainRegionAdjust((Actor)player, session);
    }
}

