/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.session;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.SessionCheck;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public class SessionManager {
    private final WorldEdit worldEdit;
    private final HashMap<String, LocalSession> sessions = new HashMap();

    public SessionManager(WorldEdit worldEdit) {
        this.worldEdit = worldEdit;
    }

    public synchronized boolean contains(Actor actor) {
        Preconditions.checkNotNull((Object)actor);
        return this.sessions.containsKey(this.getKey(actor));
    }

    @Nullable
    public synchronized LocalSession find(Actor actor) {
        Preconditions.checkNotNull((Object)actor);
        return this.sessions.get(this.getKey(actor));
    }

    @Nullable
    public synchronized LocalSession findByName(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.sessions.get(name);
    }

    public synchronized LocalSession get(Actor actor) {
        LocalSession session;
        Preconditions.checkNotNull((Object)actor);
        LocalConfiguration config = this.worldEdit.getConfiguration();
        if (this.sessions.containsKey(actor.getName())) {
            session = this.sessions.get(actor.getName());
        } else {
            session = new LocalSession(config);
            session.setBlockChangeLimit(config.defaultChangeLimit);
            this.sessions.put(actor.getName(), session);
        }
        int currentChangeLimit = session.getBlockChangeLimit();
        if (!actor.hasPermission("worldedit.limit.unrestricted") && config.maxChangeLimit > -1) {
            if (config.defaultChangeLimit < 0) {
                if (currentChangeLimit < 0 || currentChangeLimit > config.maxChangeLimit) {
                    session.setBlockChangeLimit(config.maxChangeLimit);
                }
            } else {
                int maxChangeLimit = config.maxChangeLimit;
                if (currentChangeLimit == -1 || currentChangeLimit > maxChangeLimit) {
                    session.setBlockChangeLimit(maxChangeLimit);
                }
            }
        }
        session.setUseInventory(config.useInventory && (!config.useInventoryOverride || !actor.hasPermission("worldedit.inventory.unrestricted") && (!config.useInventoryCreativeOverride || actor instanceof Player && !((Player)actor).hasCreativeMode())));
        return session;
    }

    protected String getKey(Actor actor) {
        return actor.getName();
    }

    public synchronized void markforExpiration(Actor actor) {
        Preconditions.checkNotNull((Object)actor);
        LocalSession session = this.find(actor);
        if (session != null) {
            session.update();
        }
    }

    public synchronized void remove(Actor actor) {
        Preconditions.checkNotNull((Object)actor);
        this.sessions.remove(actor.getName());
    }

    public synchronized void clear() {
        this.sessions.clear();
    }

    public synchronized void removeExpired(SessionCheck checker) {
        Iterator<Map.Entry<String, LocalSession>> it = this.sessions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, LocalSession> entry = it.next();
            if (!entry.getValue().hasExpired() || checker.isOnlinePlayer(entry.getKey())) continue;
            it.remove();
        }
    }
}

