/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.storage;

import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.storage.McRegionChunkStore;
import com.sk89q.worldedit.world.storage.MissingChunkException;
import com.sk89q.worldedit.world.storage.MissingWorldException;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipException;

public class TrueZipMcRegionChunkStore
extends McRegionChunkStore {
    protected File zipFile;
    protected ZipFile zip;
    protected String folder;

    public TrueZipMcRegionChunkStore(File zipFile, String folder) throws IOException, ZipException {
        this.zipFile = zipFile;
        this.folder = folder;
        this.zip = new ZipFile(zipFile);
    }

    public TrueZipMcRegionChunkStore(File zipFile) throws IOException, ZipException {
        this.zipFile = zipFile;
        this.zip = new ZipFile(zipFile);
    }

    @Override
    protected InputStream getInputStream(String name, String worldname) throws IOException, DataException {
        ZipEntry entry;
        if (this.folder != null) {
            if (!this.folder.equals("")) {
                name = this.folder + "/" + name;
            }
        } else {
            Pattern pattern = Pattern.compile(".*\\.mc[ra]$");
            Pattern worldPattern = Pattern.compile(worldname + "\\$");
            Enumeration e = this.zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry testEntry = (ZipEntry)e.nextElement();
                if (!worldPattern.matcher(worldname).matches() || !pattern.matcher(testEntry.getName()).matches()) continue;
                this.folder = testEntry.getName().substring(0, testEntry.getName().lastIndexOf("/"));
                name = this.folder + "/" + name;
                break;
            }
            if (this.folder == null) {
                throw new MissingWorldException("Target world is not present in ZIP.", worldname);
            }
        }
        if ((entry = this.getEntry(name)) == null) {
            throw new MissingChunkException();
        }
        try {
            return this.zip.getInputStream(entry);
        }
        catch (ZipException e) {
            throw new IOException("Failed to read " + name + " in ZIP");
        }
    }

    private ZipEntry getEntry(String file) {
        ZipEntry entry = this.zip.getEntry(file);
        if (entry != null) {
            return entry;
        }
        return this.zip.getEntry(file.replace("/", "\\"));
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    @Override
    public boolean isValid() {
        Enumeration e = this.zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry testEntry = (ZipEntry)e.nextElement();
            if (!testEntry.getName().matches(".*\\.mcr$") && !testEntry.getName().matches(".*\\.mca$")) continue;
            return true;
        }
        return false;
    }
}

