/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.FlagStateManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;

public class WorldGuardVehicleListener
implements Listener {
    private WorldGuardPlugin plugin;

    public WorldGuardVehicleListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        Vehicle vehicle = event.getVehicle();
        Entity destroyer = event.getAttacker();
        if (!(destroyer instanceof Player)) {
            return;
        }
        Player player = (Player)destroyer;
        World world = vehicle.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions) {
            Vector pt = BukkitUtil.toVector(vehicle.getLocation());
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (!(this.plugin.getGlobalRegionManager().hasBypass(player, world) || set.canBuild(localPlayer) || set.allows(DefaultFlag.DESTROY_VEHICLE, localPlayer))) {
                player.sendMessage(ChatColor.DARK_RED + "You don't have permission to destroy vehicles here.");
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (vehicle.getPassenger() == null || !(vehicle.getPassenger() instanceof Player)) {
            return;
        }
        Player player = (Player)vehicle.getPassenger();
        World world = vehicle.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions && (event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockY() != event.getTo().getBlockY() || event.getFrom().getBlockZ() != event.getTo().getBlockZ())) {
            FlagStateManager.PlayerFlagState state = this.plugin.getFlagStateManager().getState(player);
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            boolean hasBypass = this.plugin.getGlobalRegionManager().hasBypass(player, world);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            Vector pt = new Vector(event.getTo().getBlockX(), event.getTo().getBlockY(), event.getTo().getBlockZ());
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            boolean entryAllowed = set.allows(DefaultFlag.ENTRY, localPlayer);
            if (!hasBypass && !entryAllowed) {
                vehicle.setVelocity(new org.bukkit.util.Vector(0, 0, 0));
                vehicle.teleport(event.getFrom());
                return;
            }
            if (state.lastExitAllowed == null) {
                state.lastExitAllowed = mgr.getApplicableRegions(BukkitUtil.toVector(event.getFrom())).allows(DefaultFlag.EXIT, localPlayer);
            }
            boolean exitAllowed = set.allows(DefaultFlag.EXIT, localPlayer);
            if (!hasBypass && exitAllowed && !state.lastExitAllowed.booleanValue()) {
                player.sendMessage(ChatColor.DARK_RED + "You are not permitted to leave this area.");
                vehicle.setVelocity(new org.bukkit.util.Vector(0, 0, 0));
                vehicle.teleport(event.getFrom());
                return;
            }
            String greeting = (String)set.getFlag(DefaultFlag.GREET_MESSAGE, localPlayer);
            String farewell = (String)set.getFlag(DefaultFlag.FAREWELL_MESSAGE, localPlayer);
            Boolean notifyEnter = (Boolean)set.getFlag(DefaultFlag.NOTIFY_ENTER, localPlayer);
            Boolean notifyLeave = (Boolean)set.getFlag(DefaultFlag.NOTIFY_LEAVE, localPlayer);
            if (!(state.lastFarewell == null || farewell != null && state.lastFarewell.equals(farewell))) {
                String replacedFarewell = this.plugin.replaceMacros((CommandSender)player, BukkitUtil.replaceColorMacros(state.lastFarewell));
                player.sendMessage(ChatColor.AQUA + " ** " + replacedFarewell);
            }
            if (!(greeting == null || state.lastGreeting != null && state.lastGreeting.equals(greeting))) {
                String replacedGreeting = this.plugin.replaceMacros((CommandSender)player, BukkitUtil.replaceColorMacros(greeting));
                player.sendMessage(ChatColor.AQUA + " ** " + replacedGreeting);
            }
            if ((notifyLeave == null || !notifyLeave.booleanValue()) && state.notifiedForLeave != null && state.notifiedForLeave.booleanValue()) {
                this.plugin.broadcastNotification(ChatColor.GRAY + "WG: " + ChatColor.LIGHT_PURPLE + player.getName() + ChatColor.GOLD + " left NOTIFY region");
            }
            if (notifyEnter != null && notifyEnter.booleanValue() && (state.notifiedForEnter == null || !state.notifiedForEnter.booleanValue())) {
                StringBuilder regionList = new StringBuilder();
                for (ProtectedRegion region : set) {
                    if (regionList.length() != 0) {
                        regionList.append(", ");
                    }
                    regionList.append(region.getId());
                }
                this.plugin.broadcastNotification(ChatColor.GRAY + "WG: " + ChatColor.LIGHT_PURPLE + player.getName() + ChatColor.GOLD + " entered NOTIFY region: " + ChatColor.WHITE + regionList);
            }
            state.lastGreeting = greeting;
            state.lastFarewell = farewell;
            state.notifiedForEnter = notifyEnter;
            state.notifiedForLeave = notifyLeave;
            state.lastExitAllowed = exitAllowed;
            state.lastWorld = event.getTo().getWorld();
            state.lastBlockX = event.getTo().getBlockX();
            state.lastBlockY = event.getTo().getBlockY();
            state.lastBlockZ = event.getTo().getBlockZ();
        }
    }
}

