/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.cause.Cause;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.UseBlockEvent;
import com.sk89q.worldguard.bukkit.event.entity.AbstractEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.DamageEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.DestroyEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.SpawnEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.UseEntityEvent;
import com.sk89q.worldguard.bukkit.event.inventory.UseItemEvent;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import com.sk89q.worldguard.bukkit.listener.BlockStateAsBlockFunction;
import com.sk89q.worldguard.bukkit.listener.debounce.BlockPistonExtendKey;
import com.sk89q.worldguard.bukkit.listener.debounce.BlockPistonRetractKey;
import com.sk89q.worldguard.bukkit.listener.debounce.EventDebounce;
import com.sk89q.worldguard.bukkit.listener.debounce.legacy.AbstractEventDebounce;
import com.sk89q.worldguard.bukkit.listener.debounce.legacy.BlockEntityEventDebounce;
import com.sk89q.worldguard.bukkit.listener.debounce.legacy.EntityEntityEventDebounce;
import com.sk89q.worldguard.bukkit.listener.debounce.legacy.InventoryMoveItemEventDebounce;
import com.sk89q.worldguard.bukkit.util.Blocks;
import com.sk89q.worldguard.bukkit.util.Events;
import com.sk89q.worldguard.bukkit.util.Materials;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Hopper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Dispenser;
import org.bukkit.material.MaterialData;
import org.bukkit.material.SpawnEgg;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class EventAbstractionListener
extends AbstractListener {
    private final BlockEntityEventDebounce interactDebounce = new BlockEntityEventDebounce(10000);
    private final EntityEntityEventDebounce pickupDebounce = new EntityEntityEventDebounce(10000);
    private final BlockEntityEventDebounce entityBreakBlockDebounce = new BlockEntityEventDebounce(10000);
    private final InventoryMoveItemEventDebounce moveItemDebounce = new InventoryMoveItemEventDebounce(30000);
    private final EventDebounce<BlockPistonRetractKey> pistonRetractDebounce = EventDebounce.create(5000);
    private final EventDebounce<BlockPistonExtendKey> pistonExtendDebounce = EventDebounce.create(5000);

    public EventAbstractionListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    @Override
    public void registerEvents() {
        super.registerEvents();
        try {
            this.getPlugin().getServer().getPluginManager().registerEvents((Listener)new SpigotCompatListener(), (Plugin)this.getPlugin());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Events.fireToCancel((Cancellable)event, new BreakBlockEvent((Event)event, Cause.create(event.getPlayer()), event.getBlock()));
        if (event.isCancelled()) {
            this.playDenyEffect(event.getPlayer(), event.getBlock().getLocation().add(0.5, 1.0, 0.5));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        BlockState previousState = event.getBlockReplacedState();
        if (previousState.getType() != Material.AIR) {
            Events.fireToCancel((Cancellable)event, new BreakBlockEvent((Event)event, Cause.create(event.getPlayer()), previousState.getLocation(), previousState.getType()));
        }
        if (!event.isCancelled()) {
            ItemStack itemStack = new ItemStack(event.getBlockPlaced().getType(), 1);
            Events.fireToCancel((Cancellable)event, new UseItemEvent((Event)event, Cause.create(event.getPlayer()), event.getPlayer().getWorld(), itemStack));
        }
        if (!event.isCancelled()) {
            Events.fireToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, Cause.create(event.getPlayer()), event.getBlock()));
        }
        if (event.isCancelled()) {
            this.playDenyEffect(event.getPlayer(), event.getBlockPlaced().getLocation().add(0.5, 0.5, 0.5));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Block target = event.getBlock();
        Block[] adjacent = new Block[]{target.getRelative(BlockFace.NORTH), target.getRelative(BlockFace.SOUTH), target.getRelative(BlockFace.WEST), target.getRelative(BlockFace.EAST), target.getRelative(BlockFace.UP), target.getRelative(BlockFace.DOWN)};
        int found = 0;
        boolean allowed = false;
        for (Block source : adjacent) {
            if (source.getType() != Material.FIRE) continue;
            ++found;
            if (Events.fireAndTestCancel(new BreakBlockEvent((Event)event, Cause.create(source), target))) {
                source.setType(Material.AIR);
                continue;
            }
            allowed = true;
        }
        if (found > 0 && !allowed) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onStructureGrowEvent(StructureGrowEvent event) {
        int originalCount = event.getBlocks().size();
        List blockList = Lists.transform((List)event.getBlocks(), (Function)new BlockStateAsBlockFunction());
        Player player = event.getPlayer();
        if (player != null) {
            Events.fireBulkEventToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, Cause.create(player), event.getLocation().getWorld(), blockList, Material.AIR));
        } else {
            Events.fireBulkEventToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, Cause.create(event.getLocation().getBlock()), event.getLocation().getWorld(), blockList, Material.AIR));
        }
        if (!event.isCancelled() && event.getBlocks().size() != originalCount) {
            event.getLocation().getBlock().setType(Material.AIR);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        Material to = event.getTo();
        if (Materials.isRedstoneOre(block.getType()) && Materials.isRedstoneOre(to)) {
            return;
        }
        if (event.getTo() != Material.AIR && event.getBlock().getType() != Material.AIR) {
            Events.fireToCancel((Cancellable)event, new BreakBlockEvent((Event)event, Cause.create(entity), block));
            Events.fireToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, Cause.create(entity), block.getLocation(), to));
        } else if (event.getTo() == Material.AIR) {
            if (entity instanceof FallingBlock) {
                Cause.trackParentCause((Metadatable)entity, block);
                Events.fireToCancel((Cancellable)event, new SpawnEntityEvent((Event)event, Cause.create(block), entity));
            } else {
                this.entityBreakBlockDebounce.debounce(event.getBlock(), event.getEntity(), (Cancellable)event, new BreakBlockEvent((Event)event, Cause.create(entity), event.getBlock()));
            }
        } else {
            boolean wasCancelled = event.isCancelled();
            Cause cause = Cause.create(entity);
            Events.fireToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, cause, event.getBlock().getLocation(), to));
            if (event.isCancelled() && !wasCancelled && entity instanceof FallingBlock) {
                FallingBlock fallingBlock = (FallingBlock)entity;
                ItemStack itemStack = new ItemStack(fallingBlock.getMaterial(), 1, (short)fallingBlock.getBlockData());
                Item item = block.getWorld().dropItem(fallingBlock.getLocation(), itemStack);
                item.setVelocity(new Vector());
                if (Events.fireAndTestCancel(new SpawnEntityEvent((Event)event, Cause.create(block, entity), (Entity)item))) {
                    item.remove();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        Events.fireBulkEventToCancel((Cancellable)event, new BreakBlockEvent((Event)event, Cause.create(entity), event.getLocation().getWorld(), event.blockList(), Material.AIR));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        EventDebounce.Entry entry;
        if (event.isSticky() && (entry = this.pistonRetractDebounce.getIfNotPresent(new BlockPistonRetractKey(event), (Cancellable)event)) != null) {
            Cause cause = Cause.create(event.getBlock());
            Events.fireToCancel((Cancellable)event, new BreakBlockEvent((Event)event, cause, event.getRetractLocation(), Material.AIR));
            Events.fireToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, cause, event.getBlock().getRelative(event.getDirection())));
            entry.setCancelled(event.isCancelled());
            if (event.isCancelled()) {
                this.playDenyEffect(event.getBlock().getLocation().add(0.5, 1.0, 0.5));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        EventDebounce.Entry entry = this.pistonExtendDebounce.getIfNotPresent(new BlockPistonExtendKey(event), (Cancellable)event);
        if (entry != null) {
            ArrayList<Block> blocks = new ArrayList<Block>(event.getBlocks());
            Block lastBlock = event.getBlock().getRelative(event.getDirection(), event.getLength() + 1);
            blocks.add(lastBlock);
            int originalLength = blocks.size();
            Events.fireBulkEventToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, Cause.create(event.getBlock()), event.getBlock().getWorld(), blocks, Material.STONE));
            if (blocks.size() != originalLength) {
                event.setCancelled(true);
            }
            entry.setCancelled(event.isCancelled());
            if (event.isCancelled()) {
                this.playDenyEffect(event.getBlock().getLocation().add(0.5, 1.0, 0.5));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent event) {
        Block target = event.getBlock();
        if (target.getType() == Material.CAKE_BLOCK) {
            Events.fireToCancel((Cancellable)event, new UseBlockEvent((Event)event, Cause.create(event.getPlayer()), target));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getItemInHand();
        Block clicked = event.getClickedBlock();
        boolean silent = false;
        Cause cause = Cause.create(player);
        switch (event.getAction()) {
            case PHYSICAL: {
                if (Materials.isRedstoneOre(clicked.getType()) || clicked.getType() == Material.SOIL) {
                    silent = true;
                }
                this.interactDebounce.debounce(clicked, (Entity)event.getPlayer(), (Cancellable)event, new UseBlockEvent((Event)event, cause, clicked).setSilent(silent).setAllowed(this.hasInteractBypass(clicked)));
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                Block placed = clicked.getRelative(event.getBlockFace());
                EventAbstractionListener.handleBlockRightClick(event, Cause.create(event.getPlayer()), item, clicked, event.getBlockFace(), placed);
            }
            case LEFT_CLICK_BLOCK: {
                Block placed = clicked.getRelative(event.getBlockFace());
                boolean modifiesWorld = this.isBlockModifiedOnClick(clicked, event.getAction() == Action.RIGHT_CLICK_BLOCK) || item != null && this.isItemAppliedToBlock(item, clicked);
                if (Events.fireAndTestCancel(new UseBlockEvent((Event)event, cause, clicked).setAllowed(!modifiesWorld))) {
                    event.setUseInteractedBlock(Event.Result.DENY);
                }
                for (Block connected : Blocks.getConnected(clicked)) {
                    if (!Events.fireAndTestCancel(new UseBlockEvent((Event)event, Cause.create(event.getPlayer()), connected).setAllowed(!modifiesWorld))) continue;
                    event.setUseInteractedBlock(Event.Result.DENY);
                    break;
                }
                if (event.getAction() == Action.LEFT_CLICK_BLOCK && placed.getType() == Material.FIRE && Events.fireAndTestCancel(new BreakBlockEvent((Event)event, Cause.create(event.getPlayer()), placed))) {
                    event.setUseInteractedBlock(Event.Result.DENY);
                    break;
                }
                if (event.isCancelled()) {
                    this.playDenyEffect(event.getPlayer(), clicked.getLocation().add(0.5, 1.0, 0.5));
                }
            }
            case LEFT_CLICK_AIR: 
            case RIGHT_CLICK_AIR: {
                if (item != null && !item.getType().isBlock() && Events.fireAndTestCancel(new UseItemEvent((Event)event, cause, player.getWorld(), item))) {
                    event.setUseItemInHand(Event.Result.DENY);
                    event.setCancelled(true);
                }
                if (item == null || !this.getWorldConfig((World)player.getWorld()).blockUseAtFeet.test(item) || !Events.fireAndTestCancel(new UseBlockEvent((Event)event, cause, player.getLocation().getBlock()))) break;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        this.interactDebounce.debounce(event.getBlock(), event.getEntity(), (Cancellable)event, new UseBlockEvent((Event)event, Cause.create(event.getEntity()), event.getBlock()).setAllowed(this.hasInteractBypass(event.getBlock())));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        Block block = event.getBlock();
        Material type = block.getType();
        Cause cause = event.getPlayer() != null ? Cause.create(event.getPlayer()) : (event.getIgnitingEntity() != null ? Cause.create(event.getIgnitingEntity()) : (event.getIgnitingBlock() != null ? Cause.create(event.getIgnitingBlock()) : Cause.unknown()));
        Events.fireToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, cause, block.getLocation(), Material.FIRE));
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        Events.fireToCancel((Cancellable)event, new UseBlockEvent((Event)event, Cause.create(event.getPlayer()), event.getBlock()));
        if (event.isCancelled()) {
            this.playDenyEffect(event.getPlayer(), event.getBlock().getLocation().add(0.5, 0.5, 0.5));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBedEnter(PlayerBedEnterEvent event) {
        Events.fireToCancel((Cancellable)event, new UseBlockEvent((Event)event, Cause.create(event.getPlayer()), event.getBed()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        Block blockAffected = event.getBlockClicked().getRelative(event.getBlockFace());
        boolean allowed = false;
        if (event.getBucket() == Material.MILK_BUCKET) {
            allowed = true;
        }
        ItemStack item = new ItemStack(event.getBucket(), 1);
        Material blockMaterial = Materials.getBucketBlockMaterial(event.getBucket());
        Events.fireToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, Cause.create(player), blockAffected.getLocation(), blockMaterial).setAllowed(allowed));
        Events.fireToCancel((Cancellable)event, new UseItemEvent((Event)event, Cause.create(player), player.getWorld(), item).setAllowed(allowed));
        if (event.isCancelled()) {
            this.playDenyEffect(event.getPlayer(), blockAffected.getLocation().add(0.5, 0.5, 0.5));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Block blockAffected = event.getBlockClicked().getRelative(event.getBlockFace());
        boolean allowed = false;
        if (event.getBucket() == Material.MILK_BUCKET) {
            allowed = true;
        }
        ItemStack item = new ItemStack(event.getBucket(), 1);
        Events.fireToCancel((Cancellable)event, new BreakBlockEvent((Event)event, Cause.create(player), blockAffected).setAllowed(allowed));
        Events.fireToCancel((Cancellable)event, new UseItemEvent((Event)event, Cause.create(player), player.getWorld(), item).setAllowed(allowed));
        if (event.isCancelled()) {
            this.playDenyEffect(event.getPlayer(), blockAffected.getLocation().add(0.5, 0.5, 0.5));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        WorldConfiguration config = this.getWorldConfig(event.getBlock().getWorld());
        if (!config.useRegions || !config.highFreqFlags && !config.checkLiquidFlow) {
            return;
        }
        Block from = event.getBlock();
        Block to = event.getToBlock();
        Material fromType = from.getType();
        Material toType = to.getType();
        if (toType.isSolid() && Materials.isLiquid(fromType)) {
            return;
        }
        if (Materials.isWater(fromType) && Materials.isWater(toType) || Materials.isLava(fromType) && Materials.isLava(toType)) {
            return;
        }
        Cause cause = Cause.create(from);
        Events.fireToCancel((Cancellable)event, new PlaceBlockEvent((Event)event, cause, to.getLocation(), from.getType()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        switch (event.getSpawnReason()) {
            case DISPENSE_EGG: 
            case EGG: 
            case SPAWNER_EGG: {
                if (!this.getWorldConfig((World)event.getEntity().getWorld()).strictEntitySpawn) break;
                Events.fireToCancel((Cancellable)event, new SpawnEntityEvent((Event)event, Cause.unknown(), (Entity)event.getEntity()));
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        Events.fireToCancel((Cancellable)event, new SpawnEntityEvent((Event)event, Cause.create(event.getPlayer()), (Entity)event.getEntity()));
        if (event.isCancelled()) {
            Block effectBlock = event.getBlock().getRelative(event.getBlockFace());
            this.playDenyEffect(event.getPlayer(), effectBlock.getLocation().add(0.5, 0.5, 0.5));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (event instanceof HangingBreakByEntityEvent) {
            Entity remover = ((HangingBreakByEntityEvent)event).getRemover();
            Events.fireToCancel((Cancellable)event, new DestroyEntityEvent((Event)event, Cause.create(remover), (Entity)event.getEntity()));
            if (event.isCancelled() && remover instanceof Player) {
                this.playDenyEffect((Player)remover, event.getEntity().getLocation());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        Events.fireToCancel((Cancellable)event, new DestroyEntityEvent((Event)event, Cause.create(event.getAttacker()), (Entity)event.getVehicle()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockExp(BlockExpEvent event) {
        if (event.getExpToDrop() > 0 && Events.fireAndTestCancel(new SpawnEntityEvent((Event)event, Cause.create(event.getBlock()), event.getBlock().getLocation(), EntityType.EXPERIENCE_ORB))) {
            event.setExpToDrop(0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        if (Events.fireAndTestCancel(new SpawnEntityEvent((Event)event, Cause.create(event.getPlayer(), event.getHook()), event.getHook().getLocation(), EntityType.EXPERIENCE_ORB))) {
            event.setExpToDrop(0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onExpBottle(ExpBottleEvent event) {
        if (Events.fireAndTestCancel(new SpawnEntityEvent((Event)event, Cause.create(event.getEntity()), event.getEntity().getLocation(), EntityType.EXPERIENCE_ORB))) {
            Player player;
            event.setExperience(0);
            ProjectileSource shooter = event.getEntity().getShooter();
            if (shooter instanceof Player && (player = (Player)shooter).getGameMode() != GameMode.CREATIVE) {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.EXP_BOTTLE, 1)});
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getDroppedExp() > 0 && Events.fireAndTestCancel(new SpawnEntityEvent((Event)event, Cause.create(event.getEntity()), event.getEntity().getLocation(), EntityType.EXPERIENCE_ORB))) {
            event.setDroppedExp(0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        ItemStack item = player.getItemInHand();
        Entity entity = event.getRightClicked();
        Events.fireToCancel((Cancellable)event, new UseItemEvent((Event)event, Cause.create(player), world, item));
        Events.fireToCancel((Cancellable)event, new UseEntityEvent((Event)event, Cause.create(player), entity));
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event instanceof EntityDamageByBlockEvent) {
            Block attacker = ((EntityDamageByBlockEvent)event).getDamager();
            if (attacker != null) {
                Events.fireToCancel((Cancellable)event, new DamageEntityEvent((Event)event, Cause.create(attacker), event.getEntity()));
            }
        } else if (event instanceof EntityDamageByEntityEvent) {
            ItemStack item;
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)event;
            Entity damager = entityEvent.getDamager();
            Events.fireToCancel((Cancellable)event, new DamageEntityEvent((Event)event, Cause.create(damager), event.getEntity()));
            if (damager instanceof Player && (item = ((Player)damager).getItemInHand()) != null) {
                Events.fireToCancel((Cancellable)event, new UseItemEvent((Event)event, Cause.create(damager), event.getEntity().getWorld(), item));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        if (event instanceof EntityCombustByBlockEvent) {
            Events.fireToCancel((Cancellable)event, new DamageEntityEvent((Event)event, Cause.create(((EntityCombustByBlockEvent)event).getCombuster()), event.getEntity()));
        } else if (event instanceof EntityCombustByEntityEvent) {
            Events.fireToCancel((Cancellable)event, new DamageEntityEvent((Event)event, Cause.create(((EntityCombustByEntityEvent)event).getCombuster()), event.getEntity()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityUnleash(EntityUnleashEvent event) {
        if (event instanceof PlayerUnleashEntityEvent) {
            PlayerUnleashEntityEvent playerEvent = (PlayerUnleashEntityEvent)event;
            Events.fireToCancel((Cancellable)playerEvent, new UseEntityEvent((Event)playerEvent, Cause.create(playerEvent.getPlayer()), event.getEntity()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent event) {
        Events.fireToCancel((Cancellable)event, new UseEntityEvent((Event)event, Cause.create(event.getOwner()), (Entity)event.getEntity()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        Events.fireToCancel((Cancellable)event, new UseEntityEvent((Event)event, Cause.create(event.getPlayer()), event.getEntity()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Item item = event.getItem();
        this.pickupDebounce.debounce((Entity)event.getPlayer(), (Entity)item, (Cancellable)event, new DestroyEntityEvent((Event)event, Cause.create(event.getPlayer()), (Entity)event.getItem()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Events.fireToCancel((Cancellable)event, new SpawnEntityEvent((Event)event, Cause.create(event.getPlayer()), (Entity)event.getItemDrop()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleDamage(VehicleDamageEvent event) {
        Entity attacker = event.getAttacker();
        Events.fireToCancel((Cancellable)event, new DestroyEntityEvent((Event)event, Cause.create(attacker), (Entity)event.getVehicle()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleEnter(VehicleDamageEvent event) {
        Events.fireToCancel((Cancellable)event, new UseEntityEvent((Event)event, Cause.create(event.getAttacker()), (Entity)event.getVehicle()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        Events.fireToCancel((Cancellable)event, new UseItemEvent((Event)event, Cause.create(event.getPlayer()), event.getPlayer().getWorld(), event.getItem()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof BlockState) {
            Events.fireToCancel((Cancellable)event, new UseBlockEvent((Event)event, Cause.create(event.getPlayer()), ((BlockState)holder).getBlock()));
        } else if (holder instanceof Entity && !(holder instanceof Player)) {
            Events.fireToCancel((Cancellable)event, new UseEntityEvent((Event)event, Cause.create(event.getPlayer()), (Entity)holder));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        final InventoryHolder causeHolder = event.getInitiator().getHolder();
        InventoryHolder sourceHolder = event.getSource().getHolder();
        InventoryHolder targetHolder = event.getDestination().getHolder();
        AbstractEventDebounce.Entry entry = this.moveItemDebounce.tryDebounce(event);
        if (entry != null) {
            Cause cause = causeHolder instanceof Entity ? Cause.create(causeHolder) : (causeHolder instanceof BlockState ? Cause.create(((BlockState)causeHolder).getBlock()) : Cause.unknown());
            if (!causeHolder.equals(sourceHolder)) {
                EventAbstractionListener.handleInventoryHolderUse(event, cause, sourceHolder);
            }
            EventAbstractionListener.handleInventoryHolderUse(event, cause, targetHolder);
            if (event.isCancelled() && causeHolder instanceof Hopper) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        ((Hopper)causeHolder).getBlock().breakNaturally();
                    }
                });
            } else {
                entry.setCancelled(event.isCancelled());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        ThrownPotion entity = event.getEntity();
        ThrownPotion potion = event.getPotion();
        World world = entity.getWorld();
        Cause cause = Cause.create(potion);
        Events.fireToCancel((Cancellable)event, new UseItemEvent((Event)event, cause, world, potion.getItem()));
        if (!event.isCancelled()) {
            int blocked = 0;
            boolean hasDamageEffect = Materials.hasDamageEffect(potion.getEffects());
            for (LivingEntity affected : event.getAffectedEntities()) {
                AbstractEntityEvent delegate = hasDamageEffect ? new DamageEntityEvent((Event)event, cause, (Entity)affected) : new UseEntityEvent((Event)event, cause, (Entity)affected);
                delegate.getRelevantFlags().add(DefaultFlag.POTION_SPLASH);
                if (!Events.fireAndTestCancel(delegate)) continue;
                event.setIntensity(affected, 0.0);
                ++blocked;
            }
            if (blocked == event.getAffectedEntities().size()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        Cause cause = Cause.create(event.getBlock());
        Block dispenserBlock = event.getBlock();
        ItemStack item = event.getItem();
        MaterialData materialData = dispenserBlock.getState().getData();
        Events.fireToCancel((Cancellable)event, new UseItemEvent((Event)event, cause, dispenserBlock.getWorld(), item));
        if (materialData instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)materialData;
            Block placed = dispenserBlock.getRelative(dispenser.getFacing());
            Block clicked = placed.getRelative(dispenser.getFacing());
            EventAbstractionListener.handleBlockRightClick(event, cause, item, clicked, dispenser.getFacing().getOppositeFace(), placed);
        }
    }

    private static <T extends Event> void handleBlockRightClick(T event, Cause cause, @Nullable ItemStack item, Block clicked, BlockFace faceClicked, Block placed) {
        MaterialData data;
        if (item != null && item.getType() == Material.TNT) {
            Events.fireToCancel((Cancellable)event, new UseBlockEvent(event, cause, clicked.getLocation(), Material.TNT));
        }
        if (item != null && Materials.isMinecart(item.getType())) {
            Events.fireToCancel((Cancellable)event, new SpawnEntityEvent(event, cause, placed.getLocation().add(0.5, 0.0, 0.5), EntityType.MINECART));
        }
        if (item != null && item.getType() == Material.BOAT) {
            Events.fireToCancel((Cancellable)event, new SpawnEntityEvent(event, cause, placed.getLocation().add(0.5, 0.0, 0.5), EntityType.BOAT));
        }
        if (item != null && item.getType() == Materials.ARMOR_STAND) {
            Events.fireToCancel((Cancellable)event, new SpawnEntityEvent(event, cause, placed.getLocation().add(0.5, 0.0, 0.5), EntityType.ARMOR_STAND));
        }
        if (item != null && item.getType() == Material.MONSTER_EGG && (data = item.getData()) instanceof SpawnEgg) {
            EntityType type = ((SpawnEgg)data).getSpawnedType();
            if (type == null) {
                type = EntityType.SHEEP;
            }
            Events.fireToCancel((Cancellable)event, new SpawnEntityEvent(event, cause, placed.getLocation().add(0.5, 0.0, 0.5), type));
        }
        if (item != null && item.getType() == Material.INK_SACK && Materials.isDyeColor(item.getData(), DyeColor.BROWN) && faceClicked != BlockFace.DOWN && faceClicked != BlockFace.UP) {
            Events.fireToCancel((Cancellable)event, new PlaceBlockEvent(event, cause, placed.getLocation(), Material.COCOA));
        }
        if (item != null && item.getType() == Material.TNT) {
            Events.fireToCancel((Cancellable)event, new PlaceBlockEvent(event, cause, placed.getLocation(), Material.TNT));
        }
    }

    private static <T extends Event> void handleInventoryHolderUse(T originalEvent, Cause cause, InventoryHolder holder) {
        if (((Cancellable)originalEvent).isCancelled()) {
            return;
        }
        if (holder instanceof Entity) {
            Events.fireToCancel((Cancellable)originalEvent, new UseEntityEvent(originalEvent, cause, (Entity)holder));
        } else if (holder instanceof BlockState) {
            Events.fireToCancel((Cancellable)originalEvent, new UseBlockEvent(originalEvent, cause, ((BlockState)holder).getBlock()));
        } else if (holder instanceof DoubleChest) {
            Events.fireToCancel((Cancellable)originalEvent, new UseBlockEvent(originalEvent, cause, ((BlockState)((DoubleChest)holder).getLeftSide()).getBlock()));
            Events.fireToCancel((Cancellable)originalEvent, new UseBlockEvent(originalEvent, cause, ((BlockState)((DoubleChest)holder).getRightSide()).getBlock()));
        }
    }

    private boolean hasInteractBypass(Block block) {
        return this.getWorldConfig((World)block.getWorld()).allowAllInteract.test(block);
    }

    private boolean hasInteractBypass(World world, ItemStack item) {
        return this.getWorldConfig((World)world).allowAllInteract.test(item);
    }

    private boolean isBlockModifiedOnClick(Block block, boolean rightClick) {
        return Materials.isBlockModifiedOnClick(block.getType(), rightClick) && !this.hasInteractBypass(block);
    }

    private boolean isItemAppliedToBlock(ItemStack item, Block clicked) {
        return Materials.isItemAppliedToBlock(item.getType(), clicked.getType()) && !this.hasInteractBypass(clicked) && !this.hasInteractBypass(clicked.getWorld(), item);
    }

    private void playDenyEffect(Player player, Location location) {
        player.playEffect(location, Effect.SMOKE, (Object)BlockFace.UP);
    }

    private void playDenyEffect(Location location) {
        location.getWorld().playEffect(location, Effect.SMOKE, (Object)BlockFace.UP);
    }

    public class SpigotCompatListener
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
            EventAbstractionListener.this.onPlayerInteractEntity((PlayerInteractEntityEvent)event);
        }
    }
}

