/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.flags;

import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.World;

class LazyLocation
extends Location {
    private final String worldName;

    @Nullable
    private static LocalWorld findWorld(String worldName) {
        return BukkitUtil.getLocalWorld((World)Bukkit.getServer().getWorld(worldName));
    }

    public LazyLocation(String worldName, Vector position, float yaw, float pitch) {
        super(LazyLocation.findWorld(worldName), position, yaw, pitch);
        this.worldName = worldName;
    }

    public LazyLocation(String worldName, Vector position) {
        super(LazyLocation.findWorld(worldName), position);
        this.worldName = worldName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public LazyLocation setAngles(float yaw, float pitch) {
        return new LazyLocation(this.worldName, this.getPosition(), yaw, pitch);
    }

    public LazyLocation setPosition(Vector position) {
        return new LazyLocation(this.worldName, position, this.getYaw(), this.getPitch());
    }

    public LazyLocation add(Vector other) {
        return this.setPosition(this.getPosition().add(other));
    }

    public LazyLocation add(double x, double y, double z) {
        return this.setPosition(this.getPosition().add(x, y, z));
    }
}

