/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.google.common.collect.Sets;
import com.sk89q.worldguard.bukkit.commands.CommandUtils;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Collections;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FarewellFlag
extends Handler {
    private Set<String> lastMessageStack = Collections.emptySet();

    public FarewellFlag(Session session) {
        super(session);
    }

    private Set<String> getMessages(Player player, ApplicableRegionSet set) {
        return Sets.newLinkedHashSet(set.queryAllValues(this.getPlugin().wrapPlayer(player), DefaultFlag.FAREWELL_MESSAGE));
    }

    @Override
    public void initialize(Player player, Location current, ApplicableRegionSet set) {
        this.lastMessageStack = this.getMessages(player, set);
    }

    @Override
    public boolean onCrossBoundary(Player player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        Set<String> messages = this.getMessages(player, toSet);
        if (!messages.isEmpty()) {
            for (ProtectedRegion region : toSet) {
                String message = (String)region.getFlag(DefaultFlag.FAREWELL_MESSAGE);
                if (message == null) continue;
                messages.add(message);
            }
        }
        for (String message : this.lastMessageStack) {
            if (messages.contains(message)) continue;
            String effective = CommandUtils.replaceColorMacros(message);
            effective = this.getPlugin().replaceMacros((CommandSender)player, effective);
            player.sendMessage(effective.replaceAll("\\\\n", "\n").split("\\n"));
            break;
        }
        this.lastMessageStack = messages;
        return true;
    }
}

