/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.entity.Player;

public class WeatherLockFlag
extends FlagValueChangeHandler<WeatherType> {
    private WeatherType initialWeather;

    public WeatherLockFlag(Session session) {
        super(session, DefaultFlag.WEATHER_LOCK);
    }

    private void updatePlayerWeather(Player player, @Nullable WeatherType value) {
        this.initialWeather = player.getPlayerWeather();
        player.setPlayerWeather(value);
    }

    @Override
    protected void onInitialValue(Player player, ApplicableRegionSet set, WeatherType value) {
        this.initialWeather = player.getPlayerWeather();
        this.updatePlayerWeather(player, value);
    }

    @Override
    protected boolean onSetValue(Player player, Location from, Location to, ApplicableRegionSet toSet, WeatherType currentValue, WeatherType lastValue, MoveType moveType) {
        this.updatePlayerWeather(player, currentValue);
        return true;
    }

    @Override
    protected boolean onAbsentValue(Player player, Location from, Location to, ApplicableRegionSet toSet, WeatherType lastValue, MoveType moveType) {
        if (this.initialWeather != null) {
            player.setPlayerWeather(this.initialWeather);
        } else {
            player.resetPlayerWeather();
        }
        this.initialWeather = null;
        return true;
    }
}

