/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class MessageFutureCallback<V>
implements FutureCallback<V> {
    private final WorldGuardPlugin plugin;
    private final CommandSender sender;
    @Nullable
    private final String success;
    @Nullable
    private final String failure;

    private MessageFutureCallback(WorldGuardPlugin plugin, CommandSender sender, @Nullable String success, @Nullable String failure) {
        this.plugin = plugin;
        this.sender = sender;
        this.success = success;
        this.failure = failure;
    }

    public void onSuccess(@Nullable V v) {
        if (this.success != null) {
            this.sender.sendMessage(ChatColor.YELLOW + this.success);
        }
    }

    public void onFailure(@Nullable Throwable throwable) {
        String failure = this.failure != null ? this.failure : "An error occurred";
        this.sender.sendMessage(ChatColor.RED + failure + ": " + this.plugin.convertThrowable(throwable));
    }

    public static <V> MessageFutureCallback<V> createRegionLoadCallback(WorldGuardPlugin plugin, CommandSender sender) {
        return new Builder(plugin, sender).onSuccess("Successfully load the region data.").build();
    }

    public static <V> MessageFutureCallback<V> createRegionSaveCallback(WorldGuardPlugin plugin, CommandSender sender) {
        return new Builder(plugin, sender).onSuccess("Successfully saved the region data.").build();
    }

    public static class Builder {
        private final WorldGuardPlugin plugin;
        private final CommandSender sender;
        @Nullable
        private String success;
        @Nullable
        private String failure;

        public Builder(WorldGuardPlugin plugin, CommandSender sender) {
            Preconditions.checkNotNull((Object)((Object)plugin));
            Preconditions.checkNotNull((Object)sender);
            this.plugin = plugin;
            this.sender = sender;
        }

        public Builder onSuccess(@Nullable String message) {
            this.success = message;
            return this;
        }

        public Builder onFailure(@Nullable String message) {
            this.failure = message;
            return this;
        }

        public <V> MessageFutureCallback<V> build() {
            return new MessageFutureCallback(this.plugin, this.sender, this.success, this.failure);
        }
    }
}

