/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.google.common.base.Predicate;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.DelegateEvent;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.UseBlockEvent;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.SignChangeEvent;

public class ChestProtectionListener
extends AbstractListener {
    public ChestProtectionListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    private void sendMessage(DelegateEvent event, Player player, String message) {
        if (!event.isSilent()) {
            player.sendMessage(message);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlaceBlock(final PlaceBlockEvent event) {
        final Player player = event.getCause().getFirstPlayer();
        if (player != null) {
            final WorldConfiguration wcfg = this.getWorldConfig(player);
            if (!wcfg.signChestProtection) {
                return;
            }
            event.filter((Predicate)new Predicate<Location>(){

                public boolean apply(Location target) {
                    if (wcfg.getChestProtection().isChest(event.getEffectiveMaterial().getId()) && wcfg.isChestProtected(target.getBlock(), player)) {
                        ChestProtectionListener.this.sendMessage(event, player, ChatColor.DARK_RED + "This spot is for a chest that you don't have permission for.");
                        return false;
                    }
                    return true;
                }
            }, true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreakBlock(final BreakBlockEvent event) {
        final Player player = event.getCause().getFirstPlayer();
        final WorldConfiguration wcfg = this.getWorldConfig(event.getWorld());
        if (!wcfg.signChestProtection) {
            return;
        }
        if (player != null) {
            event.filter((Predicate)new Predicate<Location>(){

                public boolean apply(Location target) {
                    if (wcfg.isChestProtected(target.getBlock(), player)) {
                        ChestProtectionListener.this.sendMessage(event, player, ChatColor.DARK_RED + "This chest is protected.");
                        return false;
                    }
                    return true;
                }
            }, true);
        } else {
            event.filter((Predicate)new Predicate<Location>(){

                public boolean apply(Location target) {
                    return !wcfg.isChestProtected(target.getBlock());
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseBlock(final UseBlockEvent event) {
        final Player player = event.getCause().getFirstPlayer();
        final WorldConfiguration wcfg = this.getWorldConfig(event.getWorld());
        if (!wcfg.signChestProtection) {
            return;
        }
        if (player != null) {
            event.filter((Predicate)new Predicate<Location>(){

                public boolean apply(Location target) {
                    if (wcfg.isChestProtected(target.getBlock(), player)) {
                        ChestProtectionListener.this.sendMessage(event, player, ChatColor.DARK_RED + "This chest is protected.");
                        return false;
                    }
                    return true;
                }
            }, true);
        } else {
            event.filter((Predicate)new Predicate<Location>(){

                public boolean apply(Location target) {
                    return !wcfg.isChestProtected(target.getBlock());
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        WorldConfiguration wcfg = this.getWorldConfig(player);
        if (wcfg.signChestProtection) {
            if (event.getLine(0).equalsIgnoreCase("[Lock]")) {
                if (wcfg.isChestProtectedPlacement(event.getBlock(), player)) {
                    player.sendMessage(ChatColor.DARK_RED + "You do not own the adjacent chest.");
                    event.getBlock().breakNaturally();
                    event.setCancelled(true);
                    return;
                }
                if (event.getBlock().getTypeId() != 63) {
                    player.sendMessage(ChatColor.RED + "The [Lock] sign must be a sign post, not a wall sign.");
                    event.getBlock().breakNaturally();
                    event.setCancelled(true);
                    return;
                }
                if (!event.getLine(1).equalsIgnoreCase(player.getName())) {
                    player.sendMessage(ChatColor.RED + "The first owner line must be your name.");
                    event.getBlock().breakNaturally();
                    event.setCancelled(true);
                    return;
                }
                int below = event.getBlock().getRelative(0, -1, 0).getTypeId();
                if (below == 46 || below == 12 || below == 13 || below == 63) {
                    player.sendMessage(ChatColor.RED + "That is not a safe block that you're putting this sign on.");
                    event.getBlock().breakNaturally();
                    event.setCancelled(true);
                    return;
                }
                event.setLine(0, "[Lock]");
                player.sendMessage(ChatColor.YELLOW + "A chest or double chest above is now protected.");
            }
        } else if (!wcfg.disableSignChestProtectionCheck && event.getLine(0).equalsIgnoreCase("[Lock]")) {
            player.sendMessage(ChatColor.RED + "WorldGuard's sign chest protection is disabled.");
            event.getBlock().breakNaturally();
            event.setCancelled(true);
        }
    }
}

