/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InvincibilityFlag
extends FlagValueChangeHandler<StateFlag.State> {
    @Nullable
    private StateFlag.State invincibility;

    public InvincibilityFlag(Session session) {
        super(session, DefaultFlag.INVINCIBILITY);
    }

    @Override
    protected void onInitialValue(Player player, ApplicableRegionSet set, StateFlag.State value) {
        this.invincibility = value;
    }

    @Override
    protected boolean onSetValue(Player player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State currentValue, StateFlag.State lastValue, MoveType moveType) {
        this.invincibility = currentValue;
        return true;
    }

    @Override
    protected boolean onAbsentValue(Player player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State lastValue, MoveType moveType) {
        this.invincibility = null;
        return true;
    }

    @Override
    @Nullable
    public StateFlag.State getInvincibility(Player player) {
        if (this.invincibility == StateFlag.State.DENY && this.getPlugin().hasPermission((CommandSender)player, "worldguard.god.override-regions")) {
            return null;
        }
        return this.invincibility;
    }
}

