/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.util.profile.resolver;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sk89q.worldguard.util.profile.Profile;
import com.sk89q.worldguard.util.profile.resolver.ProfileService;
import com.sk89q.worldguard.util.profile.util.HttpRequest;
import com.sk89q.worldguard.util.profile.util.UUIDs;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class HttpRepositoryService
implements ProfileService {
    public static final String MINECRAFT_AGENT = "Minecraft";
    private static final Logger log = Logger.getLogger(HttpRepositoryService.class.getCanonicalName());
    private static final int MAX_NAMES_PER_REQUEST = 100;
    private final URL profilesURL;
    private int maxRetries = 5;
    private long retryDelay = 50L;

    public HttpRepositoryService(String agent) {
        Preconditions.checkNotNull((Object)agent);
        this.profilesURL = HttpRequest.url("https://api.mojang.com/profiles/" + agent);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        Preconditions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (Object)"maxRetries must be >= 0");
        this.maxRetries = maxRetries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    @Override
    public int getIdealRequestLimit() {
        return 100;
    }

    @Override
    @Nullable
    public Profile findByName(String name) throws IOException, InterruptedException {
        ImmutableList<Profile> profiles = this.findAllByName(Arrays.asList(name));
        if (!profiles.isEmpty()) {
            return (Profile)profiles.get(0);
        }
        return null;
    }

    @Override
    public void findAllByName(Iterable<String> names, Predicate<Profile> consumer) throws IOException, InterruptedException {
        for (List partition : Iterables.partition(names, (int)100)) {
            for (Profile profile : this.query(partition)) {
                consumer.apply((Object)profile);
            }
        }
    }

    @Override
    public ImmutableList<Profile> findAllByName(Iterable<String> names) throws IOException, InterruptedException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List partition : Iterables.partition(names, (int)100)) {
            builder.addAll(this.query(partition));
        }
        return builder.build();
    }

    protected ImmutableList<Profile> query(Iterable<String> names) throws IOException, InterruptedException {
        Object result;
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        int retriesLeft = this.maxRetries;
        long retryDelay = this.retryDelay;
        while (true) {
            try {
                result = HttpRequest.post(this.profilesURL).bodyJson(names).execute().returnContent().asJson();
            }
            catch (IOException e) {
                if (retriesLeft == 0) {
                    throw e;
                }
                log.log(Level.WARNING, "Failed to query profile service -- retrying...", e);
                Thread.sleep(retryDelay);
                retryDelay *= 2L;
                --retriesLeft;
                continue;
            }
            break;
        }
        if (result instanceof Iterable) {
            for (Object entry : (Iterable)result) {
                Profile profile = HttpRepositoryService.decodeResult(entry);
                if (profile == null) continue;
                profiles.add(profile);
            }
        }
        return ImmutableList.copyOf(profiles);
    }

    @Nullable
    private static Profile decodeResult(Object entry) {
        try {
            if (entry instanceof Map) {
                Map mapEntry = (Map)entry;
                Object rawUuid = mapEntry.get("id");
                Object rawName = mapEntry.get("name");
                if (rawUuid != null && rawName != null) {
                    UUID uuid = UUID.fromString(UUIDs.addDashes(String.valueOf(rawUuid)));
                    String name = String.valueOf(rawName);
                    return new Profile(uuid, name);
                }
            }
        }
        catch (ClassCastException e) {
            log.log(Level.WARNING, "Got invalid value from UUID lookup service", e);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Got invalid value from UUID lookup service", e);
        }
        return null;
    }

    public static ProfileService forMinecraft() {
        return new HttpRepositoryService(MINECRAFT_AGENT);
    }
}

