/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.blacklist.target;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sk89q.worldguard.blacklist.target.Target;
import com.sk89q.worldguard.blacklist.target.TargetMatcher;

public class DataValueRangeMatcher
implements TargetMatcher {
    private final int typeId;
    private final Predicate<Short> dataMatcher;

    public DataValueRangeMatcher(int typeId, Predicate<Short> dataMatcher) {
        Preconditions.checkNotNull(dataMatcher);
        this.typeId = typeId;
        this.dataMatcher = dataMatcher;
    }

    @Override
    public int getMatchedTypeId() {
        return this.typeId;
    }

    @Override
    public boolean test(Target target) {
        return this.typeId == target.getTypeId() && this.isDataInRange(target.getData());
    }

    private boolean isDataInRange(short data) {
        return this.dataMatcher.apply((Object)data);
    }
}

