/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener.debounce.legacy;

import com.sk89q.worldguard.bukkit.listener.debounce.legacy.AbstractEventDebounce;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.event.Cancellable;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.InventoryHolder;

public class InventoryMoveItemEventDebounce
extends AbstractEventDebounce<Key> {
    public InventoryMoveItemEventDebounce(int debounceTime) {
        super(debounceTime);
    }

    public AbstractEventDebounce.Entry tryDebounce(InventoryMoveItemEvent event) {
        return super.getEntry(new Key(event), (Cancellable)event);
    }

    private static class BlockMaterialKey {
        private final Block block;
        private final Material material;

        private BlockMaterialKey(Block block) {
            this.block = block;
            this.material = block.getType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockMaterialKey that = (BlockMaterialKey)o;
            if (!this.block.equals(that.block)) {
                return false;
            }
            return this.material == that.material;
        }

        public int hashCode() {
            int result = this.block.hashCode();
            result = 31 * result + this.material.hashCode();
            return result;
        }
    }

    protected static class Key {
        private final Object cause;
        private final Object source;
        private final Object target;

        public Key(InventoryMoveItemEvent event) {
            this.cause = this.transform(event.getInitiator().getHolder());
            this.source = this.transform(event.getSource().getHolder());
            this.target = this.transform(event.getDestination().getHolder());
        }

        private Object transform(InventoryHolder holder) {
            if (holder instanceof BlockState) {
                return new BlockMaterialKey(((BlockState)holder).getBlock());
            }
            if (holder instanceof DoubleChest) {
                return new BlockMaterialKey(((BlockState)((DoubleChest)holder).getLeftSide()).getBlock());
            }
            return holder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.cause != null ? !this.cause.equals(key.cause) : key.cause != null) {
                return false;
            }
            if (this.source != null ? !this.source.equals(key.source) : key.source != null) {
                return false;
            }
            return !(this.target != null ? !this.target.equals(key.target) : key.target != null);
        }

        public int hashCode() {
            int result = this.cause != null ? this.cause.hashCode() : 0;
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }
    }
}

