/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.material.Dye;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class Materials {
    private static final int MODIFIED_ON_RIGHT = 1;
    private static final int MODIFIED_ON_LEFT = 2;
    private static final int MODIFIES_BLOCKS = 4;
    private static final BiMap<EntityType, Material> ENTITY_ITEMS = HashBiMap.create();
    private static final Map<Material, Integer> MATERIAL_FLAGS = new HashMap<Material, Integer>();
    private static final Set<PotionEffectType> DAMAGE_EFFECTS = new HashSet<PotionEffectType>();
    public static Material ARMOR_STAND;

    private Materials() {
    }

    @Nullable
    public static Material getRelatedMaterial(EntityType type) {
        return (Material)ENTITY_ITEMS.get((Object)type);
    }

    public static Material getBucketBlockMaterial(Material type) {
        switch (type) {
            case LAVA_BUCKET: {
                return Material.LAVA;
            }
            case MILK_BUCKET: {
                return Material.WATER;
            }
        }
        return Material.WATER;
    }

    public static boolean isMushroom(Material material) {
        return material == Material.RED_MUSHROOM || material == Material.BROWN_MUSHROOM;
    }

    public static boolean isLeaf(Material material) {
        return material == Material.LEAVES || material == Material.LEAVES_2;
    }

    public static boolean isLiquid(Material material) {
        return Materials.isWater(material) || Materials.isLava(material);
    }

    public static boolean isWater(Material material) {
        return material == Material.WATER || material == Material.STATIONARY_WATER;
    }

    public static boolean isLava(Material material) {
        return material == Material.LAVA || material == Material.STATIONARY_LAVA;
    }

    public static boolean isPortal(Material material) {
        return material == Material.PORTAL || material == Material.ENDER_PORTAL;
    }

    public static boolean isDyeColor(MaterialData data, DyeColor color) {
        return data instanceof Dye && ((Dye)data).getColor() == color;
    }

    public static boolean isRailBlock(Material material) {
        return material == Material.RAILS || material == Material.ACTIVATOR_RAIL || material == Material.DETECTOR_RAIL || material == Material.POWERED_RAIL;
    }

    public static boolean isPistonBlock(Material material) {
        return material == Material.PISTON_BASE || material == Material.PISTON_STICKY_BASE;
    }

    public static boolean isMinecart(Material material) {
        return material == Material.MINECART || material == Material.COMMAND_MINECART || material == Material.EXPLOSIVE_MINECART || material == Material.HOPPER_MINECART || material == Material.POWERED_MINECART || material == Material.STORAGE_MINECART;
    }

    public static boolean isInventoryBlock(Material material) {
        return material == Material.CHEST || material == Material.JUKEBOX || material == Material.DISPENSER || material == Material.FURNACE || material == Material.BURNING_FURNACE || material == Material.BREWING_STAND || material == Material.TRAPPED_CHEST || material == Material.HOPPER || material == Material.DROPPER;
    }

    public static boolean isUseFlagApplicable(Material material) {
        switch (material) {
            case LEVER: {
                return true;
            }
            case STONE_BUTTON: {
                return true;
            }
            case WOOD_BUTTON: {
                return true;
            }
            case TRIPWIRE: {
                return true;
            }
            case WOODEN_DOOR: {
                return true;
            }
            case TRAP_DOOR: {
                return true;
            }
            case FENCE_GATE: {
                return true;
            }
            case WORKBENCH: {
                return true;
            }
            case ENCHANTMENT_TABLE: {
                return true;
            }
            case ENDER_CHEST: {
                return true;
            }
            case BEACON: {
                return true;
            }
            case ANVIL: {
                return true;
            }
            case WOOD_PLATE: {
                return true;
            }
            case STONE_PLATE: {
                return true;
            }
            case IRON_PLATE: {
                return true;
            }
            case GOLD_PLATE: {
                return true;
            }
            case SPRUCE_FENCE_GATE: {
                return true;
            }
            case BIRCH_FENCE_GATE: {
                return true;
            }
            case JUNGLE_FENCE_GATE: {
                return true;
            }
            case DARK_OAK_FENCE_GATE: {
                return true;
            }
            case ACACIA_FENCE_GATE: {
                return true;
            }
            case SPRUCE_DOOR: {
                return true;
            }
            case BIRCH_DOOR: {
                return true;
            }
            case JUNGLE_DOOR: {
                return true;
            }
            case ACACIA_DOOR: {
                return true;
            }
            case DARK_OAK_DOOR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRedstoneOre(Material type) {
        return type == Material.GLOWING_REDSTONE_ORE || type == Material.REDSTONE_ORE;
    }

    public static boolean isBlockModifiedOnClick(Material material, boolean rightClick) {
        Integer flags = MATERIAL_FLAGS.get(material);
        return flags == null || rightClick && (flags & 1) == 1 || !rightClick && (flags & 2) == 2;
    }

    public static boolean isItemAppliedToBlock(Material item, Material block) {
        Integer flags = MATERIAL_FLAGS.get(item);
        return flags == null || (flags & 4) == 4;
    }

    public static boolean isConsideredBuildingIfUsed(Material type) {
        return type == Material.DIODE_BLOCK_OFF || type == Material.DIODE_BLOCK_ON || type == Material.REDSTONE_COMPARATOR_OFF || type == Material.REDSTONE_COMPARATOR_ON;
    }

    public static boolean hasDamageEffect(Collection<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            if (!DAMAGE_EFFECTS.contains(effect.getType())) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            ARMOR_STAND = Material.ARMOR_STAND;
        }
        catch (NoSuchFieldError ignored) {
            ARMOR_STAND = null;
        }
        ENTITY_ITEMS.put((Object)EntityType.PAINTING, (Object)Material.PAINTING);
        ENTITY_ITEMS.put((Object)EntityType.ARROW, (Object)Material.ARROW);
        ENTITY_ITEMS.put((Object)EntityType.SNOWBALL, (Object)Material.SNOW_BALL);
        ENTITY_ITEMS.put((Object)EntityType.FIREBALL, (Object)Material.FIREBALL);
        ENTITY_ITEMS.put((Object)EntityType.SMALL_FIREBALL, (Object)Material.FIREWORK_CHARGE);
        ENTITY_ITEMS.put((Object)EntityType.ENDER_PEARL, (Object)Material.ENDER_PEARL);
        ENTITY_ITEMS.put((Object)EntityType.THROWN_EXP_BOTTLE, (Object)Material.EXP_BOTTLE);
        ENTITY_ITEMS.put((Object)EntityType.ITEM_FRAME, (Object)Material.ITEM_FRAME);
        ENTITY_ITEMS.put((Object)EntityType.PRIMED_TNT, (Object)Material.TNT);
        ENTITY_ITEMS.put((Object)EntityType.FIREWORK, (Object)Material.FIREWORK);
        ENTITY_ITEMS.put((Object)EntityType.MINECART_COMMAND, (Object)Material.COMMAND_MINECART);
        ENTITY_ITEMS.put((Object)EntityType.BOAT, (Object)Material.BOAT);
        ENTITY_ITEMS.put((Object)EntityType.MINECART, (Object)Material.MINECART);
        ENTITY_ITEMS.put((Object)EntityType.MINECART_CHEST, (Object)Material.STORAGE_MINECART);
        ENTITY_ITEMS.put((Object)EntityType.MINECART_FURNACE, (Object)Material.POWERED_MINECART);
        ENTITY_ITEMS.put((Object)EntityType.MINECART_TNT, (Object)Material.EXPLOSIVE_MINECART);
        ENTITY_ITEMS.put((Object)EntityType.MINECART_HOPPER, (Object)Material.HOPPER_MINECART);
        ENTITY_ITEMS.put((Object)EntityType.SPLASH_POTION, (Object)Material.POTION);
        ENTITY_ITEMS.put((Object)EntityType.EGG, (Object)Material.EGG);
        try {
            ENTITY_ITEMS.put((Object)EntityType.ARMOR_STAND, (Object)Material.ARMOR_STAND);
        }
        catch (NoSuchFieldError ignored) {
            // empty catch block
        }
        MATERIAL_FLAGS.put(Material.AIR, 0);
        MATERIAL_FLAGS.put(Material.STONE, 0);
        MATERIAL_FLAGS.put(Material.GRASS, 0);
        MATERIAL_FLAGS.put(Material.DIRT, 0);
        MATERIAL_FLAGS.put(Material.COBBLESTONE, 0);
        MATERIAL_FLAGS.put(Material.WOOD, 0);
        MATERIAL_FLAGS.put(Material.SAPLING, 0);
        MATERIAL_FLAGS.put(Material.BEDROCK, 0);
        MATERIAL_FLAGS.put(Material.WATER, 0);
        MATERIAL_FLAGS.put(Material.STATIONARY_WATER, 0);
        MATERIAL_FLAGS.put(Material.LAVA, 0);
        MATERIAL_FLAGS.put(Material.STATIONARY_LAVA, 0);
        MATERIAL_FLAGS.put(Material.SAND, 0);
        MATERIAL_FLAGS.put(Material.GRAVEL, 0);
        MATERIAL_FLAGS.put(Material.GOLD_ORE, 0);
        MATERIAL_FLAGS.put(Material.IRON_ORE, 0);
        MATERIAL_FLAGS.put(Material.COAL_ORE, 0);
        MATERIAL_FLAGS.put(Material.LOG, 0);
        MATERIAL_FLAGS.put(Material.LEAVES, 0);
        MATERIAL_FLAGS.put(Material.SPONGE, 0);
        MATERIAL_FLAGS.put(Material.GLASS, 0);
        MATERIAL_FLAGS.put(Material.LAPIS_ORE, 0);
        MATERIAL_FLAGS.put(Material.LAPIS_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.DISPENSER, 1);
        MATERIAL_FLAGS.put(Material.SANDSTONE, 0);
        MATERIAL_FLAGS.put(Material.NOTE_BLOCK, 1);
        MATERIAL_FLAGS.put(Material.BED_BLOCK, 1);
        MATERIAL_FLAGS.put(Material.POWERED_RAIL, 0);
        MATERIAL_FLAGS.put(Material.DETECTOR_RAIL, 0);
        MATERIAL_FLAGS.put(Material.PISTON_STICKY_BASE, 0);
        MATERIAL_FLAGS.put(Material.WEB, 0);
        MATERIAL_FLAGS.put(Material.LONG_GRASS, 0);
        MATERIAL_FLAGS.put(Material.DEAD_BUSH, 0);
        MATERIAL_FLAGS.put(Material.PISTON_BASE, 0);
        MATERIAL_FLAGS.put(Material.PISTON_EXTENSION, 0);
        MATERIAL_FLAGS.put(Material.WOOL, 0);
        MATERIAL_FLAGS.put(Material.PISTON_MOVING_PIECE, 0);
        MATERIAL_FLAGS.put(Material.YELLOW_FLOWER, 0);
        MATERIAL_FLAGS.put(Material.RED_ROSE, 0);
        MATERIAL_FLAGS.put(Material.BROWN_MUSHROOM, 0);
        MATERIAL_FLAGS.put(Material.RED_MUSHROOM, 0);
        MATERIAL_FLAGS.put(Material.GOLD_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.IRON_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.DOUBLE_STEP, 0);
        MATERIAL_FLAGS.put(Material.STEP, 0);
        MATERIAL_FLAGS.put(Material.BRICK, 0);
        MATERIAL_FLAGS.put(Material.TNT, 1);
        MATERIAL_FLAGS.put(Material.BOOKSHELF, 0);
        MATERIAL_FLAGS.put(Material.MOSSY_COBBLESTONE, 0);
        MATERIAL_FLAGS.put(Material.OBSIDIAN, 0);
        MATERIAL_FLAGS.put(Material.TORCH, 0);
        MATERIAL_FLAGS.put(Material.FIRE, 0);
        MATERIAL_FLAGS.put(Material.MOB_SPAWNER, 1);
        MATERIAL_FLAGS.put(Material.WOOD_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.CHEST, 1);
        MATERIAL_FLAGS.put(Material.REDSTONE_WIRE, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_ORE, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.WORKBENCH, 1);
        MATERIAL_FLAGS.put(Material.CROPS, 0);
        MATERIAL_FLAGS.put(Material.SOIL, 0);
        MATERIAL_FLAGS.put(Material.FURNACE, 1);
        MATERIAL_FLAGS.put(Material.BURNING_FURNACE, 1);
        MATERIAL_FLAGS.put(Material.SIGN_POST, 0);
        MATERIAL_FLAGS.put(Material.WOODEN_DOOR, 1);
        MATERIAL_FLAGS.put(Material.LADDER, 0);
        MATERIAL_FLAGS.put(Material.RAILS, 0);
        MATERIAL_FLAGS.put(Material.COBBLESTONE_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.WALL_SIGN, 0);
        MATERIAL_FLAGS.put(Material.LEVER, 1);
        MATERIAL_FLAGS.put(Material.STONE_PLATE, 0);
        MATERIAL_FLAGS.put(Material.IRON_DOOR_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.WOOD_PLATE, 0);
        MATERIAL_FLAGS.put(Material.REDSTONE_ORE, 0);
        MATERIAL_FLAGS.put(Material.GLOWING_REDSTONE_ORE, 0);
        MATERIAL_FLAGS.put(Material.REDSTONE_TORCH_OFF, 0);
        MATERIAL_FLAGS.put(Material.REDSTONE_TORCH_ON, 0);
        MATERIAL_FLAGS.put(Material.STONE_BUTTON, 1);
        MATERIAL_FLAGS.put(Material.SNOW, 0);
        MATERIAL_FLAGS.put(Material.ICE, 0);
        MATERIAL_FLAGS.put(Material.SNOW_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.CACTUS, 0);
        MATERIAL_FLAGS.put(Material.CLAY, 0);
        MATERIAL_FLAGS.put(Material.SUGAR_CANE_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.JUKEBOX, 1);
        MATERIAL_FLAGS.put(Material.FENCE, 0);
        MATERIAL_FLAGS.put(Material.PUMPKIN, 0);
        MATERIAL_FLAGS.put(Material.NETHERRACK, 0);
        MATERIAL_FLAGS.put(Material.SOUL_SAND, 0);
        MATERIAL_FLAGS.put(Material.GLOWSTONE, 0);
        MATERIAL_FLAGS.put(Material.PORTAL, 0);
        MATERIAL_FLAGS.put(Material.JACK_O_LANTERN, 0);
        MATERIAL_FLAGS.put(Material.CAKE_BLOCK, 1);
        MATERIAL_FLAGS.put(Material.DIODE_BLOCK_OFF, 1);
        MATERIAL_FLAGS.put(Material.DIODE_BLOCK_ON, 1);
        MATERIAL_FLAGS.put(Material.STAINED_GLASS, 0);
        MATERIAL_FLAGS.put(Material.TRAP_DOOR, 1);
        MATERIAL_FLAGS.put(Material.MONSTER_EGGS, 0);
        MATERIAL_FLAGS.put(Material.SMOOTH_BRICK, 0);
        MATERIAL_FLAGS.put(Material.HUGE_MUSHROOM_1, 0);
        MATERIAL_FLAGS.put(Material.HUGE_MUSHROOM_2, 0);
        MATERIAL_FLAGS.put(Material.IRON_FENCE, 0);
        MATERIAL_FLAGS.put(Material.THIN_GLASS, 0);
        MATERIAL_FLAGS.put(Material.MELON_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.PUMPKIN_STEM, 0);
        MATERIAL_FLAGS.put(Material.MELON_STEM, 0);
        MATERIAL_FLAGS.put(Material.VINE, 0);
        MATERIAL_FLAGS.put(Material.FENCE_GATE, 1);
        MATERIAL_FLAGS.put(Material.BRICK_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.SMOOTH_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.MYCEL, 0);
        MATERIAL_FLAGS.put(Material.WATER_LILY, 0);
        MATERIAL_FLAGS.put(Material.NETHER_BRICK, 0);
        MATERIAL_FLAGS.put(Material.NETHER_FENCE, 0);
        MATERIAL_FLAGS.put(Material.NETHER_BRICK_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.NETHER_WARTS, 0);
        MATERIAL_FLAGS.put(Material.ENCHANTMENT_TABLE, 1);
        MATERIAL_FLAGS.put(Material.BREWING_STAND, 1);
        MATERIAL_FLAGS.put(Material.CAULDRON, 1);
        MATERIAL_FLAGS.put(Material.ENDER_PORTAL, 0);
        MATERIAL_FLAGS.put(Material.ENDER_PORTAL_FRAME, 0);
        MATERIAL_FLAGS.put(Material.ENDER_STONE, 0);
        MATERIAL_FLAGS.put(Material.DRAGON_EGG, 3);
        MATERIAL_FLAGS.put(Material.REDSTONE_LAMP_OFF, 0);
        MATERIAL_FLAGS.put(Material.REDSTONE_LAMP_ON, 0);
        MATERIAL_FLAGS.put(Material.WOOD_DOUBLE_STEP, 0);
        MATERIAL_FLAGS.put(Material.WOOD_STEP, 0);
        MATERIAL_FLAGS.put(Material.COCOA, 0);
        MATERIAL_FLAGS.put(Material.SANDSTONE_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.EMERALD_ORE, 0);
        MATERIAL_FLAGS.put(Material.ENDER_CHEST, 1);
        MATERIAL_FLAGS.put(Material.TRIPWIRE_HOOK, 0);
        MATERIAL_FLAGS.put(Material.TRIPWIRE, 0);
        MATERIAL_FLAGS.put(Material.EMERALD_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.SPRUCE_WOOD_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.BIRCH_WOOD_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.JUNGLE_WOOD_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.COMMAND, 1);
        MATERIAL_FLAGS.put(Material.BEACON, 1);
        MATERIAL_FLAGS.put(Material.COBBLE_WALL, 0);
        MATERIAL_FLAGS.put(Material.FLOWER_POT, 1);
        MATERIAL_FLAGS.put(Material.CARROT, 0);
        MATERIAL_FLAGS.put(Material.POTATO, 0);
        MATERIAL_FLAGS.put(Material.WOOD_BUTTON, 1);
        MATERIAL_FLAGS.put(Material.SKULL, 0);
        MATERIAL_FLAGS.put(Material.ANVIL, 1);
        MATERIAL_FLAGS.put(Material.TRAPPED_CHEST, 1);
        MATERIAL_FLAGS.put(Material.GOLD_PLATE, 0);
        MATERIAL_FLAGS.put(Material.IRON_PLATE, 0);
        MATERIAL_FLAGS.put(Material.REDSTONE_COMPARATOR_OFF, 1);
        MATERIAL_FLAGS.put(Material.REDSTONE_COMPARATOR_ON, 1);
        MATERIAL_FLAGS.put(Material.DAYLIGHT_DETECTOR, 1);
        MATERIAL_FLAGS.put(Material.REDSTONE_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.QUARTZ_ORE, 0);
        MATERIAL_FLAGS.put(Material.HOPPER, 1);
        MATERIAL_FLAGS.put(Material.QUARTZ_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.QUARTZ_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.ACTIVATOR_RAIL, 0);
        MATERIAL_FLAGS.put(Material.DROPPER, 1);
        MATERIAL_FLAGS.put(Material.STAINED_CLAY, 0);
        MATERIAL_FLAGS.put(Material.STAINED_GLASS_PANE, 0);
        MATERIAL_FLAGS.put(Material.LEAVES_2, 0);
        MATERIAL_FLAGS.put(Material.LOG_2, 0);
        MATERIAL_FLAGS.put(Material.ACACIA_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.DARK_OAK_STAIRS, 0);
        MATERIAL_FLAGS.put(Material.HAY_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.CARPET, 0);
        MATERIAL_FLAGS.put(Material.HARD_CLAY, 0);
        MATERIAL_FLAGS.put(Material.COAL_BLOCK, 0);
        MATERIAL_FLAGS.put(Material.PACKED_ICE, 0);
        MATERIAL_FLAGS.put(Material.DOUBLE_PLANT, 0);
        try {
            MATERIAL_FLAGS.put(Material.STANDING_BANNER, 0);
            MATERIAL_FLAGS.put(Material.WALL_BANNER, 0);
            MATERIAL_FLAGS.put(Material.DAYLIGHT_DETECTOR_INVERTED, 1);
            MATERIAL_FLAGS.put(Material.RED_SANDSTONE, 0);
            MATERIAL_FLAGS.put(Material.RED_SANDSTONE_STAIRS, 0);
            MATERIAL_FLAGS.put(Material.DOUBLE_STONE_SLAB2, 0);
            MATERIAL_FLAGS.put(Material.STONE_SLAB2, 0);
            MATERIAL_FLAGS.put(Material.SPRUCE_FENCE_GATE, 1);
            MATERIAL_FLAGS.put(Material.BIRCH_FENCE_GATE, 1);
            MATERIAL_FLAGS.put(Material.JUNGLE_FENCE_GATE, 1);
            MATERIAL_FLAGS.put(Material.DARK_OAK_FENCE_GATE, 1);
            MATERIAL_FLAGS.put(Material.ACACIA_FENCE_GATE, 1);
            MATERIAL_FLAGS.put(Material.SPRUCE_FENCE, 0);
            MATERIAL_FLAGS.put(Material.BIRCH_FENCE, 0);
            MATERIAL_FLAGS.put(Material.JUNGLE_FENCE, 0);
            MATERIAL_FLAGS.put(Material.DARK_OAK_FENCE, 0);
            MATERIAL_FLAGS.put(Material.ACACIA_FENCE, 0);
            MATERIAL_FLAGS.put(Material.SPRUCE_DOOR, 1);
            MATERIAL_FLAGS.put(Material.BIRCH_DOOR, 1);
            MATERIAL_FLAGS.put(Material.JUNGLE_DOOR, 1);
            MATERIAL_FLAGS.put(Material.ACACIA_DOOR, 1);
            MATERIAL_FLAGS.put(Material.DARK_OAK_DOOR, 1);
        }
        catch (NoSuchFieldError ignored) {
            // empty catch block
        }
        MATERIAL_FLAGS.put(Material.IRON_SPADE, 0);
        MATERIAL_FLAGS.put(Material.IRON_PICKAXE, 0);
        MATERIAL_FLAGS.put(Material.IRON_AXE, 0);
        MATERIAL_FLAGS.put(Material.FLINT_AND_STEEL, 0);
        MATERIAL_FLAGS.put(Material.APPLE, 0);
        MATERIAL_FLAGS.put(Material.BOW, 0);
        MATERIAL_FLAGS.put(Material.ARROW, 0);
        MATERIAL_FLAGS.put(Material.COAL, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND, 0);
        MATERIAL_FLAGS.put(Material.IRON_INGOT, 0);
        MATERIAL_FLAGS.put(Material.GOLD_INGOT, 0);
        MATERIAL_FLAGS.put(Material.IRON_SWORD, 0);
        MATERIAL_FLAGS.put(Material.WOOD_SWORD, 0);
        MATERIAL_FLAGS.put(Material.WOOD_SPADE, 0);
        MATERIAL_FLAGS.put(Material.WOOD_PICKAXE, 0);
        MATERIAL_FLAGS.put(Material.WOOD_AXE, 0);
        MATERIAL_FLAGS.put(Material.STONE_SWORD, 0);
        MATERIAL_FLAGS.put(Material.STONE_SPADE, 0);
        MATERIAL_FLAGS.put(Material.STONE_PICKAXE, 0);
        MATERIAL_FLAGS.put(Material.STONE_AXE, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_SWORD, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_SPADE, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_PICKAXE, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_AXE, 0);
        MATERIAL_FLAGS.put(Material.STICK, 0);
        MATERIAL_FLAGS.put(Material.BOWL, 0);
        MATERIAL_FLAGS.put(Material.MUSHROOM_SOUP, 0);
        MATERIAL_FLAGS.put(Material.GOLD_SWORD, 0);
        MATERIAL_FLAGS.put(Material.GOLD_SPADE, 0);
        MATERIAL_FLAGS.put(Material.GOLD_PICKAXE, 0);
        MATERIAL_FLAGS.put(Material.GOLD_AXE, 0);
        MATERIAL_FLAGS.put(Material.STRING, 0);
        MATERIAL_FLAGS.put(Material.FEATHER, 0);
        MATERIAL_FLAGS.put(Material.SULPHUR, 0);
        MATERIAL_FLAGS.put(Material.WOOD_HOE, 4);
        MATERIAL_FLAGS.put(Material.STONE_HOE, 4);
        MATERIAL_FLAGS.put(Material.IRON_HOE, 4);
        MATERIAL_FLAGS.put(Material.DIAMOND_HOE, 4);
        MATERIAL_FLAGS.put(Material.GOLD_HOE, 4);
        MATERIAL_FLAGS.put(Material.SEEDS, 4);
        MATERIAL_FLAGS.put(Material.WHEAT, 0);
        MATERIAL_FLAGS.put(Material.BREAD, 0);
        MATERIAL_FLAGS.put(Material.LEATHER_HELMET, 0);
        MATERIAL_FLAGS.put(Material.LEATHER_CHESTPLATE, 0);
        MATERIAL_FLAGS.put(Material.LEATHER_LEGGINGS, 0);
        MATERIAL_FLAGS.put(Material.LEATHER_BOOTS, 0);
        MATERIAL_FLAGS.put(Material.CHAINMAIL_HELMET, 0);
        MATERIAL_FLAGS.put(Material.CHAINMAIL_CHESTPLATE, 0);
        MATERIAL_FLAGS.put(Material.CHAINMAIL_LEGGINGS, 0);
        MATERIAL_FLAGS.put(Material.CHAINMAIL_BOOTS, 0);
        MATERIAL_FLAGS.put(Material.IRON_HELMET, 0);
        MATERIAL_FLAGS.put(Material.IRON_CHESTPLATE, 0);
        MATERIAL_FLAGS.put(Material.IRON_LEGGINGS, 0);
        MATERIAL_FLAGS.put(Material.IRON_BOOTS, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_HELMET, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_CHESTPLATE, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_LEGGINGS, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_BOOTS, 0);
        MATERIAL_FLAGS.put(Material.GOLD_HELMET, 0);
        MATERIAL_FLAGS.put(Material.GOLD_CHESTPLATE, 0);
        MATERIAL_FLAGS.put(Material.GOLD_LEGGINGS, 0);
        MATERIAL_FLAGS.put(Material.GOLD_BOOTS, 0);
        MATERIAL_FLAGS.put(Material.FLINT, 0);
        MATERIAL_FLAGS.put(Material.PORK, 0);
        MATERIAL_FLAGS.put(Material.GRILLED_PORK, 0);
        MATERIAL_FLAGS.put(Material.PAINTING, 0);
        MATERIAL_FLAGS.put(Material.GOLDEN_APPLE, 0);
        MATERIAL_FLAGS.put(Material.SIGN, 0);
        MATERIAL_FLAGS.put(Material.WOOD_DOOR, 0);
        MATERIAL_FLAGS.put(Material.BUCKET, 0);
        MATERIAL_FLAGS.put(Material.WATER_BUCKET, 0);
        MATERIAL_FLAGS.put(Material.LAVA_BUCKET, 0);
        MATERIAL_FLAGS.put(Material.MINECART, 0);
        MATERIAL_FLAGS.put(Material.SADDLE, 0);
        MATERIAL_FLAGS.put(Material.IRON_DOOR, 0);
        MATERIAL_FLAGS.put(Material.REDSTONE, 0);
        MATERIAL_FLAGS.put(Material.SNOW_BALL, 0);
        MATERIAL_FLAGS.put(Material.BOAT, 0);
        MATERIAL_FLAGS.put(Material.LEATHER, 0);
        MATERIAL_FLAGS.put(Material.MILK_BUCKET, 0);
        MATERIAL_FLAGS.put(Material.CLAY_BRICK, 0);
        MATERIAL_FLAGS.put(Material.CLAY_BALL, 0);
        MATERIAL_FLAGS.put(Material.SUGAR_CANE, 0);
        MATERIAL_FLAGS.put(Material.PAPER, 0);
        MATERIAL_FLAGS.put(Material.BOOK, 0);
        MATERIAL_FLAGS.put(Material.SLIME_BALL, 0);
        MATERIAL_FLAGS.put(Material.STORAGE_MINECART, 0);
        MATERIAL_FLAGS.put(Material.POWERED_MINECART, 0);
        MATERIAL_FLAGS.put(Material.EGG, 0);
        MATERIAL_FLAGS.put(Material.COMPASS, 0);
        MATERIAL_FLAGS.put(Material.FISHING_ROD, 0);
        MATERIAL_FLAGS.put(Material.WATCH, 0);
        MATERIAL_FLAGS.put(Material.GLOWSTONE_DUST, 0);
        MATERIAL_FLAGS.put(Material.RAW_FISH, 0);
        MATERIAL_FLAGS.put(Material.COOKED_FISH, 0);
        MATERIAL_FLAGS.put(Material.INK_SACK, 4);
        MATERIAL_FLAGS.put(Material.BONE, 0);
        MATERIAL_FLAGS.put(Material.SUGAR, 0);
        MATERIAL_FLAGS.put(Material.CAKE, 0);
        MATERIAL_FLAGS.put(Material.BED, 0);
        MATERIAL_FLAGS.put(Material.DIODE, 0);
        MATERIAL_FLAGS.put(Material.COOKIE, 0);
        MATERIAL_FLAGS.put(Material.MAP, 0);
        MATERIAL_FLAGS.put(Material.SHEARS, 4);
        MATERIAL_FLAGS.put(Material.MELON, 0);
        MATERIAL_FLAGS.put(Material.PUMPKIN_SEEDS, 0);
        MATERIAL_FLAGS.put(Material.MELON_SEEDS, 0);
        MATERIAL_FLAGS.put(Material.RAW_BEEF, 0);
        MATERIAL_FLAGS.put(Material.COOKED_BEEF, 0);
        MATERIAL_FLAGS.put(Material.RAW_CHICKEN, 0);
        MATERIAL_FLAGS.put(Material.COOKED_CHICKEN, 0);
        MATERIAL_FLAGS.put(Material.ROTTEN_FLESH, 0);
        MATERIAL_FLAGS.put(Material.ENDER_PEARL, 0);
        MATERIAL_FLAGS.put(Material.BLAZE_ROD, 0);
        MATERIAL_FLAGS.put(Material.GHAST_TEAR, 0);
        MATERIAL_FLAGS.put(Material.GOLD_NUGGET, 0);
        MATERIAL_FLAGS.put(Material.NETHER_STALK, 0);
        MATERIAL_FLAGS.put(Material.POTION, 0);
        MATERIAL_FLAGS.put(Material.GLASS_BOTTLE, 0);
        MATERIAL_FLAGS.put(Material.SPIDER_EYE, 0);
        MATERIAL_FLAGS.put(Material.FERMENTED_SPIDER_EYE, 0);
        MATERIAL_FLAGS.put(Material.BLAZE_POWDER, 0);
        MATERIAL_FLAGS.put(Material.MAGMA_CREAM, 0);
        MATERIAL_FLAGS.put(Material.BREWING_STAND_ITEM, 0);
        MATERIAL_FLAGS.put(Material.CAULDRON_ITEM, 0);
        MATERIAL_FLAGS.put(Material.EYE_OF_ENDER, 0);
        MATERIAL_FLAGS.put(Material.SPECKLED_MELON, 0);
        MATERIAL_FLAGS.put(Material.MONSTER_EGG, 0);
        MATERIAL_FLAGS.put(Material.EXP_BOTTLE, 0);
        MATERIAL_FLAGS.put(Material.FIREBALL, 0);
        MATERIAL_FLAGS.put(Material.BOOK_AND_QUILL, 0);
        MATERIAL_FLAGS.put(Material.WRITTEN_BOOK, 0);
        MATERIAL_FLAGS.put(Material.EMERALD, 0);
        MATERIAL_FLAGS.put(Material.ITEM_FRAME, 0);
        MATERIAL_FLAGS.put(Material.FLOWER_POT_ITEM, 0);
        MATERIAL_FLAGS.put(Material.CARROT_ITEM, 0);
        MATERIAL_FLAGS.put(Material.POTATO_ITEM, 0);
        MATERIAL_FLAGS.put(Material.BAKED_POTATO, 0);
        MATERIAL_FLAGS.put(Material.POISONOUS_POTATO, 0);
        MATERIAL_FLAGS.put(Material.EMPTY_MAP, 0);
        MATERIAL_FLAGS.put(Material.GOLDEN_CARROT, 0);
        MATERIAL_FLAGS.put(Material.SKULL_ITEM, 0);
        MATERIAL_FLAGS.put(Material.CARROT_STICK, 0);
        MATERIAL_FLAGS.put(Material.NETHER_STAR, 0);
        MATERIAL_FLAGS.put(Material.PUMPKIN_PIE, 0);
        MATERIAL_FLAGS.put(Material.FIREWORK, 0);
        MATERIAL_FLAGS.put(Material.FIREWORK_CHARGE, 0);
        MATERIAL_FLAGS.put(Material.ENCHANTED_BOOK, 0);
        MATERIAL_FLAGS.put(Material.REDSTONE_COMPARATOR, 0);
        MATERIAL_FLAGS.put(Material.NETHER_BRICK_ITEM, 0);
        MATERIAL_FLAGS.put(Material.QUARTZ, 0);
        MATERIAL_FLAGS.put(Material.EXPLOSIVE_MINECART, 0);
        MATERIAL_FLAGS.put(Material.HOPPER_MINECART, 0);
        MATERIAL_FLAGS.put(Material.IRON_BARDING, 0);
        MATERIAL_FLAGS.put(Material.GOLD_BARDING, 0);
        MATERIAL_FLAGS.put(Material.DIAMOND_BARDING, 0);
        MATERIAL_FLAGS.put(Material.LEASH, 0);
        MATERIAL_FLAGS.put(Material.NAME_TAG, 0);
        MATERIAL_FLAGS.put(Material.COMMAND_MINECART, 0);
        try {
            MATERIAL_FLAGS.put(Material.PRISMARINE_SHARD, 0);
            MATERIAL_FLAGS.put(Material.PRISMARINE_CRYSTALS, 0);
            MATERIAL_FLAGS.put(Material.RABBIT, 0);
            MATERIAL_FLAGS.put(Material.COOKED_RABBIT, 0);
            MATERIAL_FLAGS.put(Material.RABBIT_STEW, 0);
            MATERIAL_FLAGS.put(Material.RABBIT_FOOT, 0);
            MATERIAL_FLAGS.put(Material.RABBIT_HIDE, 0);
            MATERIAL_FLAGS.put(Material.ARMOR_STAND, 0);
            MATERIAL_FLAGS.put(Material.IRON_BARDING, 0);
            MATERIAL_FLAGS.put(Material.GOLD_BARDING, 0);
            MATERIAL_FLAGS.put(Material.DIAMOND_BARDING, 0);
            MATERIAL_FLAGS.put(Material.MUTTON, 0);
            MATERIAL_FLAGS.put(Material.COOKED_MUTTON, 0);
            MATERIAL_FLAGS.put(Material.BANNER, 0);
            MATERIAL_FLAGS.put(Material.SPRUCE_DOOR_ITEM, 0);
            MATERIAL_FLAGS.put(Material.BIRCH_DOOR_ITEM, 0);
            MATERIAL_FLAGS.put(Material.JUNGLE_DOOR_ITEM, 0);
            MATERIAL_FLAGS.put(Material.ACACIA_DOOR_ITEM, 0);
            MATERIAL_FLAGS.put(Material.DARK_OAK_DOOR_ITEM, 0);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        MATERIAL_FLAGS.put(Material.GOLD_RECORD, 0);
        MATERIAL_FLAGS.put(Material.GREEN_RECORD, 0);
        MATERIAL_FLAGS.put(Material.RECORD_3, 0);
        MATERIAL_FLAGS.put(Material.RECORD_4, 0);
        MATERIAL_FLAGS.put(Material.RECORD_5, 0);
        MATERIAL_FLAGS.put(Material.RECORD_6, 0);
        MATERIAL_FLAGS.put(Material.RECORD_7, 0);
        MATERIAL_FLAGS.put(Material.RECORD_8, 0);
        MATERIAL_FLAGS.put(Material.RECORD_9, 0);
        MATERIAL_FLAGS.put(Material.RECORD_10, 0);
        MATERIAL_FLAGS.put(Material.RECORD_11, 0);
        MATERIAL_FLAGS.put(Material.RECORD_12, 0);
        DAMAGE_EFFECTS.add(PotionEffectType.BLINDNESS);
        DAMAGE_EFFECTS.add(PotionEffectType.CONFUSION);
        DAMAGE_EFFECTS.add(PotionEffectType.HARM);
        DAMAGE_EFFECTS.add(PotionEffectType.HUNGER);
        DAMAGE_EFFECTS.add(PotionEffectType.POISON);
        DAMAGE_EFFECTS.add(PotionEffectType.SLOW);
        DAMAGE_EFFECTS.add(PotionEffectType.SLOW_DIGGING);
        DAMAGE_EFFECTS.add(PotionEffectType.WEAKNESS);
        DAMAGE_EFFECTS.add(PotionEffectType.WITHER);
    }
}

