/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitPlayer
extends com.sk89q.worldedit.bukkit.BukkitPlayer
implements LocalPlayer {
    protected final WorldGuardPlugin plugin;
    private final boolean silenced;
    private String name;

    public BukkitPlayer(WorldGuardPlugin plugin, Player player) {
        this(plugin, player, false);
    }

    BukkitPlayer(WorldGuardPlugin plugin, Player player, boolean silenced) {
        super(player);
        this.plugin = plugin;
        this.silenced = silenced;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getPlayer().getName();
        }
        return this.name;
    }

    public boolean hasGroup(String group) {
        return this.plugin.inGroup((OfflinePlayer)this.getPlayer(), group);
    }

    public void kick(String msg) {
        if (!this.silenced) {
            this.getPlayer().kickPlayer(msg);
        }
    }

    public void ban(String msg) {
        if (!this.silenced) {
            Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(this.getName(), null, null, null);
            this.getPlayer().kickPlayer(msg);
        }
    }

    public double getHealth() {
        return this.getPlayer().getHealth();
    }

    public void setHealth(double health) {
        this.getPlayer().setHealth(health);
    }

    public double getMaxHealth() {
        return this.getPlayer().getMaxHealth();
    }

    public double getFoodLevel() {
        return this.getPlayer().getFoodLevel();
    }

    public void setFoodLevel(double foodLevel) {
        this.getPlayer().setFoodLevel((int)foodLevel);
    }

    public double getSaturation() {
        return this.getPlayer().getSaturation();
    }

    public void setSaturation(double saturation) {
        this.getPlayer().setSaturation((float)saturation);
    }

    public float getExhaustion() {
        return this.getPlayer().getExhaustion();
    }

    public void setExhaustion(float exhaustion) {
        this.getPlayer().setExhaustion(exhaustion);
    }

    public WeatherType getPlayerWeather() {
        return null;
    }

    public void setPlayerWeather(WeatherType weather) {
        this.getPlayer().setPlayerWeather(weather == WeatherTypes.CLEAR ? org.bukkit.WeatherType.CLEAR : org.bukkit.WeatherType.DOWNFALL);
    }

    public void resetPlayerWeather() {
        this.getPlayer().resetPlayerWeather();
    }

    public boolean isPlayerTimeRelative() {
        return this.getPlayer().isPlayerTimeRelative();
    }

    public long getPlayerTimeOffset() {
        return this.getPlayer().getPlayerTimeOffset();
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getPlayer().setPlayerTime(time, relative);
    }

    public void resetPlayerTime() {
        this.getPlayer().resetPlayerTime();
    }

    public int getFireTicks() {
        return this.getPlayer().getFireTicks();
    }

    public void setFireTicks(int fireTicks) {
        this.getPlayer().setFireTicks(fireTicks);
    }

    public void setCompassTarget(Location location) {
        this.getPlayer().setCompassTarget(BukkitAdapter.adapt((Location)location));
    }

    public void sendTitle(String title, String subtitle) {
        this.getPlayer().sendTitle(title, subtitle, -1, -1, -1);
    }

    public void resetFallDistance() {
        this.getPlayer().setFallDistance(0.0f);
    }

    public String[] getGroups() {
        return this.plugin.getGroups((OfflinePlayer)this.getPlayer());
    }

    public void printRaw(String msg) {
        if (!this.silenced) {
            super.printRaw(msg);
        }
    }

    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.getPlayer(), perm);
    }
}

