/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.cause;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sk89q.worldguard.bukkit.internal.WGMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.metadata.Metadatable;

public final class Cause {
    private static final String CAUSE_KEY = "worldguard.cause";
    private static final Cause UNKNOWN = new Cause(Collections.emptyList(), false);
    private final List<Object> causes;
    private final boolean indirect;

    private Cause(List<Object> causes, boolean indirect) {
        Preconditions.checkNotNull(causes);
        this.causes = causes;
        this.indirect = indirect;
    }

    public boolean isIndirect() {
        return this.indirect;
    }

    public boolean isKnown() {
        if (this.causes.isEmpty()) {
            return false;
        }
        boolean found = false;
        for (Object object : this.causes) {
            if (object instanceof TNTPrimed || object instanceof Vehicle) continue;
            found = true;
            break;
        }
        return found;
    }

    @Nullable
    public Object getRootCause() {
        if (!this.causes.isEmpty()) {
            return this.causes.get(0);
        }
        return null;
    }

    @Nullable
    public Player getFirstPlayer() {
        for (Object object : this.causes) {
            if (!(object instanceof Player)) continue;
            return (Player)object;
        }
        return null;
    }

    @Nullable
    public Entity getFirstEntity() {
        for (Object object : this.causes) {
            if (!(object instanceof Entity)) continue;
            return (Entity)object;
        }
        return null;
    }

    @Nullable
    public Entity getFirstNonPlayerEntity() {
        for (Object object : this.causes) {
            if (!(object instanceof Entity) || object instanceof Player) continue;
            return (Entity)object;
        }
        return null;
    }

    @Nullable
    public Block getFirstBlock() {
        for (Object object : this.causes) {
            if (!(object instanceof Block)) continue;
            return (Block)object;
        }
        return null;
    }

    @Nullable
    public EntityType find(EntityType ... types) {
        for (Object object : this.causes) {
            if (!(object instanceof Entity)) continue;
            for (EntityType type : types) {
                if (((Entity)object).getType() != type) continue;
                return type;
            }
        }
        return null;
    }

    public String toString() {
        return Joiner.on((String)" | ").join(this.causes);
    }

    public static Cause create(Object ... cause) {
        if (cause != null) {
            Builder builder = new Builder(cause.length);
            builder.addAll(cause);
            return builder.build();
        }
        return UNKNOWN;
    }

    public static Cause unknown() {
        return UNKNOWN;
    }

    public static void trackParentCause(Metadatable target, Object parent) {
        if (target instanceof Block) {
            throw new IllegalArgumentException("Can't track causes on Blocks because Cause doesn't check block metadata");
        }
        WGMetadata.put(target, CAUSE_KEY, parent);
    }

    private static final class Builder {
        private final List<Object> causes;
        private final Set<Object> seen = Sets.newHashSet();
        private boolean indirect;

        private Builder(int expectedSize) {
            this.causes = new ArrayList<Object>(expectedSize);
        }

        private void addAll(Object ... element) {
            if (element != null) {
                for (Object o : element) {
                    if (o == null || this.seen.contains(o)) continue;
                    this.seen.add(o);
                    if (o instanceof TNTPrimed) {
                        this.addAll(((TNTPrimed)o).getSource());
                    } else if (o instanceof Projectile) {
                        this.addAll(((Projectile)o).getShooter());
                    } else if (o instanceof Vehicle) {
                        this.addAll(((Vehicle)o).getPassengers());
                    } else if (o instanceof AreaEffectCloud) {
                        this.indirect = true;
                        this.addAll(((AreaEffectCloud)o).getSource());
                    } else if (o instanceof Creature && ((Creature)o).getTarget() != null) {
                        this.indirect = true;
                        this.addAll(((Creature)o).getTarget());
                    } else if (o instanceof Tameable) {
                        this.indirect = true;
                        this.addAll(((Tameable)o).getOwner());
                    }
                    Object source = o;
                    int index = this.causes.size();
                    while (source instanceof Metadatable && !(source instanceof Block)) {
                        if ((source = WGMetadata.getIfPresent((Metadatable)source, Cause.CAUSE_KEY, Object.class)) == null) continue;
                        this.causes.add(index, source);
                        this.seen.add(source);
                    }
                    this.causes.add(o);
                }
            }
        }

        public Cause build() {
            return new Cause(this.causes, this.indirect);
        }
    }
}

