/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.report.Report;
import com.sk89q.worldedit.util.report.ReportList;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitConfigurationManager;
import com.sk89q.worldguard.bukkit.BukkitDebugHandler;
import com.sk89q.worldguard.bukkit.BukkitPlayer;
import com.sk89q.worldguard.bukkit.BukkitRegionContainer;
import com.sk89q.worldguard.bukkit.BukkitStringMatcher;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.protection.events.flags.FlagContextCreateEvent;
import com.sk89q.worldguard.bukkit.session.BukkitSessionManager;
import com.sk89q.worldguard.bukkit.util.report.PerformanceReport;
import com.sk89q.worldguard.bukkit.util.report.PluginReport;
import com.sk89q.worldguard.bukkit.util.report.SchedulerReport;
import com.sk89q.worldguard.bukkit.util.report.ServerReport;
import com.sk89q.worldguard.bukkit.util.report.ServicesReport;
import com.sk89q.worldguard.bukkit.util.report.WorldReport;
import com.sk89q.worldguard.internal.platform.DebugHandler;
import com.sk89q.worldguard.internal.platform.StringMatcher;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class BukkitWorldGuardPlatform
implements WorldGuardPlatform {
    private SessionManager sessionManager;
    private BukkitConfigurationManager configuration;
    private BukkitRegionContainer regionContainer;
    private BukkitDebugHandler debugHandler;
    private StringMatcher stringMatcher;

    public String getPlatformName() {
        return "Bukkit-Official";
    }

    public String getPlatformVersion() {
        return WorldGuardPlugin.inst().getDescription().getVersion();
    }

    public void notifyFlagContextCreate(FlagContext.FlagContextBuilder flagContextBuilder) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new FlagContextCreateEvent(flagContextBuilder));
    }

    public BukkitConfigurationManager getGlobalStateManager() {
        return this.configuration;
    }

    public StringMatcher getMatcher() {
        return this.stringMatcher;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void broadcastNotification(String message) {
        Bukkit.broadcast((String)message, (String)"worldguard.notify");
        Set subs = Bukkit.getPluginManager().getPermissionSubscriptions("worldguard.notify");
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (subs.contains(player) && player.hasPermission("worldguard.notify") || !WorldGuardPlugin.inst().hasPermission((CommandSender)player, "worldguard.notify")) continue;
            player.sendMessage(message);
        }
        WorldGuard.logger.info(message);
    }

    public void broadcastNotification(TextComponent component) {
        List wgPlayers = Bukkit.getServer().getOnlinePlayers().stream().map(player -> WorldGuardPlugin.inst().wrapPlayer((Player)player)).collect(Collectors.toList());
        for (LocalPlayer player2 : wgPlayers) {
            if (!player2.hasPermission("worldguard.notify")) continue;
            player2.print((Component)component);
        }
    }

    public void load() {
        this.stringMatcher = new BukkitStringMatcher();
        this.sessionManager = new BukkitSessionManager();
        this.configuration = new BukkitConfigurationManager(WorldGuardPlugin.inst());
        this.configuration.load();
        this.regionContainer = new BukkitRegionContainer(WorldGuardPlugin.inst());
        this.regionContainer.initialize();
        this.debugHandler = new BukkitDebugHandler(WorldGuardPlugin.inst());
    }

    public void unload() {
        this.configuration.unload();
        this.regionContainer.shutdown();
    }

    public RegionContainer getRegionContainer() {
        return this.regionContainer;
    }

    public DebugHandler getDebugHandler() {
        return this.debugHandler;
    }

    public GameMode getDefaultGameMode() {
        return GameModes.get((String)Bukkit.getServer().getDefaultGameMode().name().toLowerCase());
    }

    public Path getConfigDir() {
        return WorldGuardPlugin.inst().getDataFolder().toPath();
    }

    public void stackPlayerInventory(LocalPlayer localPlayer) {
        boolean ignoreMax = localPlayer.hasPermission("worldguard.stack.illegitimate");
        boolean ignoreDamaged = localPlayer.hasPermission("worldguard.stack.damaged");
        Player player = ((BukkitPlayer)localPlayer).getPlayer();
        ItemStack[] items = player.getInventory().getContents();
        int len = items.length;
        int affected = 0;
        block0: for (int i = 0; i < len; ++i) {
            int max;
            ItemStack item = items[i];
            if (item == null || item.getAmount() <= 0 || !ignoreMax && item.getMaxStackSize() == 1) continue;
            int n = max = ignoreMax ? 64 : item.getMaxStackSize();
            if (item.getAmount() >= max) continue;
            int needed = max - item.getAmount();
            for (int j = i + 1; j < len; ++j) {
                ItemStack item2 = items[j];
                if (item2 == null || item2.getAmount() <= 0 || !ignoreMax && item.getMaxStackSize() == 1 || item2.getType() != item.getType() || !ignoreDamaged && item.getDurability() != item2.getDurability() || (item.getItemMeta() != null || item2.getItemMeta() != null) && (item.getItemMeta() == null || !item.getItemMeta().equals(item2.getItemMeta()))) continue;
                if (item2.getAmount() > needed) {
                    item.setAmount(max);
                    item2.setAmount(item2.getAmount() - needed);
                    continue block0;
                }
                items[j] = null;
                item.setAmount(item.getAmount() + item2.getAmount());
                needed = max - item.getAmount();
                ++affected;
            }
        }
        if (affected > 0) {
            player.getInventory().setContents(items);
        }
    }

    public void addPlatformReports(ReportList report) {
        report.add((Report)new ServerReport());
        report.add((Report)new PluginReport());
        report.add((Report)new SchedulerReport());
        report.add((Report)new ServicesReport());
        report.add((Report)new WorldReport());
        report.add((Report)new PerformanceReport());
    }
}

