/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

class AbstractListener
implements Listener {
    private final WorldGuardPlugin plugin;

    public AbstractListener(WorldGuardPlugin plugin) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    protected WorldGuardPlugin getPlugin() {
        return this.plugin;
    }

    protected static ConfigurationManager getConfig() {
        return WorldGuard.getInstance().getPlatform().getGlobalStateManager();
    }

    protected static WorldConfiguration getWorldConfig(World world) {
        return AbstractListener.getConfig().get(world);
    }

    protected static WorldConfiguration getWorldConfig(LocalPlayer player) {
        return AbstractListener.getWorldConfig((World)player.getExtent());
    }

    protected static boolean isRegionSupportEnabled(World world) {
        return AbstractListener.getWorldConfig((World)world).useRegions;
    }
}

