/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.cause.Cause;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.DelayedRegionOverlapAssociation;
import com.sk89q.worldguard.protection.association.Associables;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import io.papermc.lib.PaperLib;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

class AbstractListener
implements Listener {
    private final WorldGuardPlugin plugin;

    public AbstractListener(WorldGuardPlugin plugin) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    protected WorldGuardPlugin getPlugin() {
        return this.plugin;
    }

    protected static ConfigurationManager getConfig() {
        return WorldGuard.getInstance().getPlatform().getGlobalStateManager();
    }

    protected static WorldConfiguration getWorldConfig(World world) {
        return AbstractListener.getConfig().get(world);
    }

    protected static WorldConfiguration getWorldConfig(LocalPlayer player) {
        return AbstractListener.getWorldConfig((World)player.getExtent());
    }

    protected static boolean isRegionSupportEnabled(World world) {
        return AbstractListener.getWorldConfig((World)world).useRegions;
    }

    protected RegionAssociable createRegionAssociable(Cause cause) {
        Object rootCause = cause.getRootCause();
        if (!cause.isKnown()) {
            return Associables.constant((Association)Association.NON_MEMBER);
        }
        if (rootCause instanceof Player) {
            return this.getPlugin().wrapPlayer((Player)rootCause);
        }
        if (rootCause instanceof OfflinePlayer) {
            return this.getPlugin().wrapOfflinePlayer((OfflinePlayer)rootCause);
        }
        if (rootCause instanceof Entity) {
            Location loc;
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            Entity entity = (Entity)rootCause;
            if (PaperLib.isPaper() && ((BukkitWorldConfiguration)AbstractListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)entity.getWorld()))).usePaperEntityOrigin) {
                loc = entity.getOrigin();
                if (loc == null) {
                    loc = entity.getLocation();
                }
            } else {
                loc = entity.getLocation();
            }
            return new DelayedRegionOverlapAssociation(query, BukkitAdapter.adapt((Location)loc));
        }
        if (rootCause instanceof Block) {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            return new DelayedRegionOverlapAssociation(query, BukkitAdapter.adapt((Location)((Block)rootCause).getLocation()));
        }
        return Associables.constant((Association)Association.NON_MEMBER);
    }
}

