/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.commands;

import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.Style;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class CommandUtils {
    private CommandUtils() {
    }

    public static String replaceColorMacros(String str) {
        str = str.replace("`r", Style.RED.toString());
        str = str.replace("`R", Style.RED_DARK.toString());
        str = str.replace("`y", Style.YELLOW.toString());
        str = str.replace("`Y", Style.YELLOW_DARK.toString());
        str = str.replace("`g", Style.GREEN.toString());
        str = str.replace("`G", Style.GREEN_DARK.toString());
        str = str.replace("`c", Style.CYAN.toString());
        str = str.replace("`C", Style.CYAN_DARK.toString());
        str = str.replace("`b", Style.BLUE.toString());
        str = str.replace("`B", Style.BLUE_DARK.toString());
        str = str.replace("`p", Style.PURPLE.toString());
        str = str.replace("`P", Style.PURPLE_DARK.toString());
        str = str.replace("`0", Style.BLACK.toString());
        str = str.replace("`1", Style.GRAY_DARK.toString());
        str = str.replace("`2", Style.GRAY.toString());
        str = str.replace("`w", Style.WHITE.toString());
        str = str.replace("`k", Style.RANDOMIZE.toString());
        str = str.replace("`l", Style.BOLD.toString());
        str = str.replace("`m", Style.STRIKETHROUGH.toString());
        str = str.replace("`n", Style.UNDERLINE.toString());
        str = str.replace("`o", Style.ITALIC.toString());
        str = str.replace("`x", Style.RESET.toString());
        str = Style.translateAlternateColorCodes((char)'&', (String)str);
        return str;
    }

    public static String getOwnerName(@Nullable Object owner) {
        if (owner == null) {
            return "?";
        }
        if (owner instanceof Actor) {
            return ((Actor)owner).getName();
        }
        return "?";
    }

    public static Function<String, ?> messageFunction(Actor sender) {
        return s -> {
            sender.printRaw(s);
            return null;
        };
    }
}

