/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.google.common.collect.Sets;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.commands.CommandUtils;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Collections;
import java.util.Set;

public class FarewellFlag
extends Handler {
    public static final Factory FACTORY = new Factory();
    private Set<String> lastMessageStack = Collections.emptySet();

    public FarewellFlag(Session session) {
        super(session);
    }

    private Set<String> getMessages(LocalPlayer player, ApplicableRegionSet set) {
        return Sets.newLinkedHashSet(set.queryAllValues(player, Flags.FAREWELL_MESSAGE));
    }

    @Override
    public void initialize(LocalPlayer player, Location current, ApplicableRegionSet set) {
        this.lastMessageStack = this.getMessages(player, set);
    }

    @Override
    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        Set<String> messages = this.getMessages(player, toSet);
        if (!messages.isEmpty()) {
            for (ProtectedRegion region : toSet) {
                String message = (String)region.getFlag(Flags.FAREWELL_MESSAGE);
                if (message == null) continue;
                messages.add(message);
            }
        }
        for (String message : this.lastMessageStack) {
            if (messages.contains(message)) continue;
            String effective = CommandUtils.replaceColorMacros(message);
            effective = WorldGuard.getInstance().getPlatform().getMatcher().replaceMacros((Actor)player, effective);
            for (String mess : effective.replaceAll("\\\\n", "\n").split("\\n")) {
                player.printRaw(mess);
            }
        }
        this.lastMessageStack = messages;
        return true;
    }

    public static class Factory
    extends Handler.Factory<FarewellFlag> {
        @Override
        public FarewellFlag create(Session session) {
            return new FarewellFlag(session);
        }
    }
}

