/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.commands.region;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.AsyncCommandHelper;
import com.sk89q.worldedit.command.util.FutureProgressListener;
import com.sk89q.worldedit.command.util.MessageFutureCallback;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.command.parametric.ExceptionConverter;
import com.sk89q.worldedit.util.formatting.Style;
import com.sk89q.worldedit.util.task.Supervisor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.commands.CommandUtils;
import com.sk89q.worldguard.commands.region.RegionCommandsBase;
import com.sk89q.worldguard.commands.region.RegionPrintoutBuilder;
import com.sk89q.worldguard.commands.task.RegionAdder;
import com.sk89q.worldguard.commands.task.RegionLister;
import com.sk89q.worldguard.commands.task.RegionManagerReloader;
import com.sk89q.worldguard.commands.task.RegionManagerSaver;
import com.sk89q.worldguard.commands.task.RegionRemover;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.internal.permission.RegionPermissionModel;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.flags.RegionGroupFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.managers.RemovalStrategy;
import com.sk89q.worldguard.protection.managers.migration.DriverMigration;
import com.sk89q.worldguard.protection.managers.migration.MigrationException;
import com.sk89q.worldguard.protection.managers.migration.UUIDMigration;
import com.sk89q.worldguard.protection.managers.storage.DriverType;
import com.sk89q.worldguard.protection.managers.storage.RegionDriver;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.util.DomainInputResolver;
import com.sk89q.worldguard.util.Enums;
import com.sk89q.worldguard.util.logging.LoggerToChatHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RegionCommands
extends RegionCommandsBase {
    private static final Logger log = Logger.getLogger(RegionCommands.class.getCanonicalName());
    private final WorldGuard worldGuard;

    public RegionCommands(WorldGuard worldGuard) {
        Preconditions.checkNotNull((Object)worldGuard);
        this.worldGuard = worldGuard;
    }

    @Command(aliases={"define", "def", "d", "create"}, usage="<id> [<owner1> [<owner2> [<owners...>]]]", flags="ng", desc="Defines a region", min=1)
    public void define(CommandContext args, Actor sender) throws CommandException {
        ProtectedRegion region;
        RegionCommands.warnAboutSaveFailures(sender);
        LocalPlayer player = this.worldGuard.checkPlayer(sender);
        if (!RegionCommands.getPermissionModel((Actor)player).mayDefine()) {
            throw new CommandPermissionsException();
        }
        String id = RegionCommands.checkRegionId(args.getString(0), false);
        RegionManager manager = RegionCommands.checkRegionManager(player.getWorld());
        RegionCommands.checkRegionDoesNotExist(manager, id, true);
        if (args.hasFlag('g')) {
            region = new GlobalProtectedRegion(id);
        } else {
            region = RegionCommands.checkRegionFromSelection(player, id);
            RegionCommands.warnAboutDimensions((Actor)player, region);
            RegionCommands.informNewUser((Actor)player, manager, region);
        }
        RegionAdder task = new RegionAdder(manager, region);
        task.addOwnersFromCommand(args, 2);
        ListenableFuture future = WorldGuard.getInstance().getExecutorService().submit((Callable)task);
        AsyncCommandHelper.wrap((ListenableFuture)future, (Supervisor)this.worldGuard.getSupervisor(), (Actor)player, (ExceptionConverter)this.worldGuard.getExceptionConverter()).formatUsing(new Object[]{id}).registerWithSupervisor("Adding the region '%s'...").sendMessageAfterDelay("(Please wait... adding '%s'...)").thenRespondWith("A new region has been made named '%s'.", "Failed to add the region '%s'");
    }

    @Command(aliases={"redefine", "update", "move"}, usage="<id>", desc="Re-defines the shape of a region", flags="g", min=1, max=1)
    public void redefine(CommandContext args, Actor sender) throws CommandException {
        ProtectedRegion region;
        RegionCommands.warnAboutSaveFailures(sender);
        LocalPlayer player = this.worldGuard.checkPlayer(sender);
        String id = RegionCommands.checkRegionId(args.getString(0), false);
        RegionManager manager = RegionCommands.checkRegionManager(player.getWorld());
        ProtectedRegion existing = RegionCommands.checkExistingRegion(manager, id, false);
        if (!RegionCommands.getPermissionModel((Actor)player).mayRedefine(existing)) {
            throw new CommandPermissionsException();
        }
        if (args.hasFlag('g')) {
            region = new GlobalProtectedRegion(id);
        } else {
            region = RegionCommands.checkRegionFromSelection(player, id);
            RegionCommands.warnAboutDimensions((Actor)player, region);
            RegionCommands.informNewUser((Actor)player, manager, region);
        }
        region.copyFrom(existing);
        RegionAdder task = new RegionAdder(manager, region);
        ListenableFuture future = WorldGuard.getInstance().getExecutorService().submit((Callable)task);
        AsyncCommandHelper.wrap((ListenableFuture)future, (Supervisor)this.worldGuard.getSupervisor(), (Actor)player, (ExceptionConverter)this.worldGuard.getExceptionConverter()).formatUsing(new Object[]{id}).registerWithSupervisor("Updating the region '%s'...").sendMessageAfterDelay("(Please wait... updating '%s'...)").thenRespondWith("Region '%s' has been updated with a new area.", "Failed to update the region '%s'");
    }

    @Command(aliases={"claim"}, usage="<id>", desc="Claim a region", min=1, max=1)
    public void claim(CommandContext args, Actor sender) throws CommandException {
        int maxRegionCount;
        RegionCommands.warnAboutSaveFailures(sender);
        LocalPlayer player = this.worldGuard.checkPlayer(sender);
        RegionPermissionModel permModel = RegionCommands.getPermissionModel((Actor)player);
        if (!permModel.mayClaim()) {
            throw new CommandPermissionsException();
        }
        String id = RegionCommands.checkRegionId(args.getString(0), false);
        RegionManager manager = RegionCommands.checkRegionManager(player.getWorld());
        RegionCommands.checkRegionDoesNotExist(manager, id, false);
        ProtectedRegion region = RegionCommands.checkRegionFromSelection(player, id);
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(player.getWorld());
        if (!permModel.mayClaimRegionsUnbounded() && (maxRegionCount = wcfg.getMaxRegionCount(player)) >= 0 && manager.getRegionCountOfPlayer(player) >= maxRegionCount) {
            throw new CommandException("You own too many regions, delete one first to claim a new one.");
        }
        ProtectedRegion existing = manager.getRegion(id);
        if (existing != null && !existing.getOwners().contains(player)) {
            throw new CommandException("This region already exists and you don't own it.");
        }
        ApplicableRegionSet regions = manager.getApplicableRegions(region);
        if (regions.size() > 0) {
            if (!regions.isOwnerOfAll(player)) {
                throw new CommandException("This region overlaps with someone else's region.");
            }
        } else if (wcfg.claimOnlyInsideExistingRegions) {
            throw new CommandException("You may only claim regions inside existing regions that you or your group own.");
        }
        if (wcfg.maxClaimVolume >= Integer.MAX_VALUE) {
            throw new CommandException("The maximum claim volume get in the configuration is higher than is supported. Currently, it must be 2147483647 or smaller. Please contact a server administrator.");
        }
        if (!permModel.mayClaimRegionsUnbounded()) {
            if (region instanceof ProtectedPolygonalRegion) {
                throw new CommandException("Polygons are currently not supported for /rg claim.");
            }
            if (region.volume() > wcfg.maxClaimVolume) {
                player.printError("This region is too large to claim.");
                player.printError("Max. volume: " + wcfg.maxClaimVolume + ", your volume: " + region.volume());
                return;
            }
        }
        RegionAdder task = new RegionAdder(manager, region);
        task.setLocatorPolicy(DomainInputResolver.UserLocatorPolicy.UUID_ONLY);
        task.setOwnersInput(new String[]{player.getName()});
        ListenableFuture future = this.worldGuard.getExecutorService().submit((Callable)task);
        AsyncCommandHelper.wrap((ListenableFuture)future, (Supervisor)this.worldGuard.getSupervisor(), (Actor)player, (ExceptionConverter)this.worldGuard.getExceptionConverter()).formatUsing(new Object[]{id}).registerWithSupervisor("Claiming the region '%s'...").sendMessageAfterDelay("(Please wait... claiming '%s'...)").thenRespondWith("A new region has been claimed named '%s'.", "Failed to claim the region '%s'");
    }

    @Command(aliases={"select", "sel", "s"}, usage="[id]", desc="Load a region as a WorldEdit selection", min=0, max=1)
    public void select(CommandContext args, Actor sender) throws CommandException {
        LocalPlayer player = this.worldGuard.checkPlayer(sender);
        RegionManager manager = RegionCommands.checkRegionManager(player.getWorld());
        ProtectedRegion existing = args.argsLength() == 0 ? RegionCommands.checkRegionStandingIn(manager, player) : RegionCommands.checkExistingRegion(manager, args.getString(0), false);
        if (!RegionCommands.getPermissionModel((Actor)player).maySelect(existing)) {
            throw new CommandPermissionsException();
        }
        RegionCommands.setPlayerSelection(player, existing);
    }

    @Command(aliases={"info", "i"}, usage="[id]", flags="usw:", desc="Get information about a region", min=0, max=1)
    public void info(CommandContext args, Actor sender) throws CommandException {
        ProtectedRegion existing;
        RegionCommands.warnAboutSaveFailures(sender);
        World world = RegionCommands.checkWorld(args, sender, 'w');
        RegionPermissionModel permModel = RegionCommands.getPermissionModel(sender);
        RegionManager manager = RegionCommands.checkRegionManager(world);
        if (args.argsLength() == 0) {
            if (!(sender instanceof LocalPlayer)) {
                throw new CommandException("Please specify the region with /region info -w world_name region_name.");
            }
            existing = RegionCommands.checkRegionStandingIn(manager, (LocalPlayer)sender, true);
        } else {
            existing = RegionCommands.checkExistingRegion(manager, args.getString(0), true);
        }
        if (!permModel.mayLookup(existing)) {
            throw new CommandPermissionsException();
        }
        if (args.hasFlag('s')) {
            if (!permModel.maySelect(existing)) {
                throw new CommandPermissionsException();
            }
            RegionCommands.setPlayerSelection(this.worldGuard.checkPlayer(sender), existing);
        }
        RegionPrintoutBuilder printout = new RegionPrintoutBuilder(existing, args.hasFlag('u') ? null : WorldGuard.getInstance().getProfileCache());
        ListenableFuture future = Futures.transform((ListenableFuture)WorldGuard.getInstance().getExecutorService().submit((Callable)printout), CommandUtils.messageFunction(sender)::apply);
        FutureProgressListener.addProgressListener((ListenableFuture)future, (Actor)sender, (String)"(Please wait... fetching region information...)");
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new MessageFutureCallback.Builder(sender).exceptionConverter((ExceptionConverter)this.worldGuard.getExceptionConverter()).onFailure("Failed to fetch region information").build());
    }

    @Command(aliases={"list"}, usage="[page]", desc="Get a list of regions", flags="np:w:", max=1)
    public void list(CommandContext args, Actor sender) throws CommandException {
        RegionCommands.warnAboutSaveFailures(sender);
        World world = RegionCommands.checkWorld(args, sender, 'w');
        int page = args.getInteger(0, 1) - 1;
        if (page < 0) {
            page = 0;
        }
        String ownedBy = args.hasFlag('p') ? args.getFlag('p') : null;
        if (!RegionCommands.getPermissionModel(sender).mayList(ownedBy)) {
            ownedBy = sender.getName();
            if (!RegionCommands.getPermissionModel(sender).mayList(ownedBy)) {
                throw new CommandPermissionsException();
            }
        }
        RegionManager manager = RegionCommands.checkRegionManager(world);
        RegionLister task = new RegionLister(manager, sender);
        task.setPage(page);
        if (ownedBy != null) {
            task.filterOwnedByName(ownedBy, args.hasFlag('n'));
        }
        ListenableFuture future = WorldGuard.getInstance().getExecutorService().submit((Callable)task);
        AsyncCommandHelper.wrap((ListenableFuture)future, (Supervisor)this.worldGuard.getSupervisor(), (Actor)sender, (ExceptionConverter)this.worldGuard.getExceptionConverter()).registerWithSupervisor("Getting list of regions...").sendMessageAfterDelay("(Please wait... fetching region list...)").thenTellErrorsOnly("Failed to fetch region list");
    }

    @Command(aliases={"flag", "f"}, usage="<id> <flag> [-w world] [-g group] [value]", flags="g:w:e", desc="Set flags", min=2)
    public void flag(CommandContext args, Actor sender) throws CommandException {
        RegionGroupFlag groupFlag;
        RegionManager manager;
        ProtectedRegion existing;
        RegionCommands.warnAboutSaveFailures(sender);
        World world = RegionCommands.checkWorld(args, sender, 'w');
        String flagName = args.getString(1);
        String value = args.argsLength() >= 3 ? args.getJoinedStrings(2) : null;
        RegionGroup groupValue = null;
        FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
        RegionPermissionModel permModel = RegionCommands.getPermissionModel(sender);
        if (args.hasFlag('e')) {
            if (value != null) {
                throw new CommandException("You cannot use -e(mpty) with a flag value.");
            }
            value = "";
        }
        if (value != null) {
            value = CommandUtils.replaceColorMacros(value);
        }
        if (!permModel.maySetFlag(existing = RegionCommands.checkExistingRegion(manager = RegionCommands.checkRegionManager(world), args.getString(0), true))) {
            throw new CommandPermissionsException();
        }
        Flag<?> foundFlag = Flags.fuzzyMatchFlag(flagRegistry, flagName);
        if (foundFlag == null) {
            ArrayList<String> flagList = new ArrayList<String>();
            for (Flag flag : flagRegistry) {
                if (!permModel.maySetFlag(existing, flag)) continue;
                flagList.add(flag.getName());
            }
            Collections.sort(flagList);
            StringBuilder list = new StringBuilder();
            for (int i = 0; i < flagList.size(); ++i) {
                String flag = (String)flagList.get(i);
                if (i % 2 == 0) {
                    list.append(Style.GRAY);
                } else {
                    list.append(Style.WHITE);
                }
                list.append(flag);
                if (i + 1 >= flagList.size()) continue;
                list.append(", ");
            }
            sender.printError("Unknown flag specified: " + flagName);
            sender.print(Style.YELLOW + "Available flags: " + list);
            return;
        }
        if (!permModel.maySetFlag(existing, foundFlag, value)) {
            throw new CommandPermissionsException();
        }
        if (args.hasFlag('g')) {
            String group = args.getFlag('g');
            RegionGroupFlag groupFlag2 = foundFlag.getRegionGroupFlag();
            if (groupFlag2 == null) {
                throw new CommandException("Region flag '" + foundFlag.getName() + "' does not have a group flag!");
            }
            try {
                groupValue = (RegionGroup)((Object)groupFlag2.parseInput(FlagContext.create().setSender(sender).setInput(group).setObject("region", existing).build()));
            }
            catch (InvalidFlagFormat e) {
                throw new CommandException(e.getMessage());
            }
        }
        if (value != null) {
            try {
                RegionCommands.setFlag(existing, foundFlag, sender, value);
            }
            catch (InvalidFlagFormat e) {
                throw new CommandException(e.getMessage());
            }
            sender.print("Region flag " + foundFlag.getName() + " set on '" + existing.getId() + "' to '" + Style.stripColor((String)value) + "'.");
        } else if (!args.hasFlag('g')) {
            existing.setFlag(foundFlag, null);
            groupFlag = foundFlag.getRegionGroupFlag();
            if (groupFlag != null) {
                existing.setFlag(groupFlag, null);
            }
            sender.print("Region flag " + foundFlag.getName() + " removed from '" + existing.getId() + "'. (Any -g(roups) were also removed.)");
        }
        if (groupValue != null) {
            groupFlag = foundFlag.getRegionGroupFlag();
            if (groupValue == groupFlag.getDefault()) {
                existing.setFlag(groupFlag, null);
                sender.print("Region group flag for '" + foundFlag.getName() + "' reset to default.");
            } else {
                existing.setFlag(groupFlag, groupValue);
                sender.print("Region group flag for '" + foundFlag.getName() + "' set.");
            }
        }
        RegionPrintoutBuilder printout = new RegionPrintoutBuilder(existing, null);
        printout.append(Style.GRAY);
        printout.append("(Current flags: ");
        printout.appendFlagsList(false);
        printout.append(")");
        printout.send(sender);
    }

    @Command(aliases={"setpriority", "priority", "pri"}, usage="<id> <priority>", flags="w:", desc="Set the priority of a region", min=2, max=2)
    public void setPriority(CommandContext args, Actor sender) throws CommandException {
        RegionCommands.warnAboutSaveFailures(sender);
        World world = RegionCommands.checkWorld(args, sender, 'w');
        int priority = args.getInteger(1);
        RegionManager manager = RegionCommands.checkRegionManager(world);
        ProtectedRegion existing = RegionCommands.checkExistingRegion(manager, args.getString(0), false);
        if (!RegionCommands.getPermissionModel(sender).maySetPriority(existing)) {
            throw new CommandPermissionsException();
        }
        existing.setPriority(priority);
        sender.print("Priority of '" + existing.getId() + "' set to " + priority + " (higher numbers override).");
    }

    @Command(aliases={"setparent", "parent", "par"}, usage="<id> [parent-id]", flags="w:", desc="Set the parent of a region", min=1, max=2)
    public void setParent(CommandContext args, Actor sender) throws CommandException {
        RegionCommands.warnAboutSaveFailures(sender);
        World world = RegionCommands.checkWorld(args, sender, 'w');
        RegionManager manager = RegionCommands.checkRegionManager(world);
        ProtectedRegion child = RegionCommands.checkExistingRegion(manager, args.getString(0), false);
        ProtectedRegion parent = args.argsLength() == 2 ? RegionCommands.checkExistingRegion(manager, args.getString(1), false) : null;
        if (!RegionCommands.getPermissionModel(sender).maySetParent(child, parent)) {
            throw new CommandPermissionsException();
        }
        try {
            child.setParent(parent);
        }
        catch (ProtectedRegion.CircularInheritanceException e) {
            RegionPrintoutBuilder printout = new RegionPrintoutBuilder(parent, null);
            printout.append(Style.RED);
            assert (parent != null);
            printout.append("Uh oh! Setting '" + parent.getId() + "' to be the parent of '" + child.getId() + "' would cause circular inheritance.\n");
            printout.append(Style.GRAY);
            printout.append("(Current inheritance on '" + parent.getId() + "':\n");
            printout.appendParentTree(true);
            printout.append(Style.GRAY);
            printout.append(")");
            printout.send(sender);
            return;
        }
        RegionPrintoutBuilder printout = new RegionPrintoutBuilder(child, null);
        printout.append(Style.YELLOW);
        printout.append("Inheritance set for region '" + child.getId() + "'.\n");
        if (parent != null) {
            printout.append(Style.GRAY);
            printout.append("(Current inheritance:\n");
            printout.appendParentTree(true);
            printout.append(Style.GRAY);
            printout.append(")");
        }
        printout.send(sender);
    }

    @Command(aliases={"remove", "delete", "del", "rem"}, usage="<id>", flags="fuw:", desc="Remove a region", min=1, max=1)
    public void remove(CommandContext args, Actor sender) throws CommandException {
        RegionCommands.warnAboutSaveFailures(sender);
        World world = RegionCommands.checkWorld(args, sender, 'w');
        boolean removeChildren = args.hasFlag('f');
        boolean unsetParent = args.hasFlag('u');
        RegionManager manager = RegionCommands.checkRegionManager(world);
        ProtectedRegion existing = RegionCommands.checkExistingRegion(manager, args.getString(0), true);
        if (!RegionCommands.getPermissionModel(sender).mayDelete(existing)) {
            throw new CommandPermissionsException();
        }
        RegionRemover task = new RegionRemover(manager, existing);
        if (removeChildren && unsetParent) {
            throw new CommandException("You cannot use both -u (unset parent) and -f (remove children) together.");
        }
        if (removeChildren) {
            task.setRemovalStrategy(RemovalStrategy.REMOVE_CHILDREN);
        } else if (unsetParent) {
            task.setRemovalStrategy(RemovalStrategy.UNSET_PARENT_IN_CHILDREN);
        }
        AsyncCommandHelper.wrap((ListenableFuture)WorldGuard.getInstance().getExecutorService().submit((Callable)task), (Supervisor)this.worldGuard.getSupervisor(), (Actor)sender, (ExceptionConverter)this.worldGuard.getExceptionConverter()).formatUsing(new Object[]{existing.getId()}).registerWithSupervisor("Removing the region '%s'...").sendMessageAfterDelay("(Please wait... removing '%s'...)").thenRespondWith("The region named '%s' has been removed.", "Failed to remove the region '%s'");
    }

    @Command(aliases={"load", "reload"}, usage="[world]", desc="Reload regions from file", flags="w:")
    public void load(CommandContext args, Actor sender) throws CommandException {
        RegionCommands.warnAboutSaveFailures(sender);
        World world = null;
        try {
            world = RegionCommands.checkWorld(args, sender, 'w');
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        if (!RegionCommands.getPermissionModel(sender).mayForceLoadRegions()) {
            throw new CommandPermissionsException();
        }
        if (world != null) {
            RegionManager manager = RegionCommands.checkRegionManager(world);
            if (manager == null) {
                throw new CommandException("No region manager exists for world '" + world.getName() + "'.");
            }
            ListenableFuture future = WorldGuard.getInstance().getExecutorService().submit((Callable)new RegionManagerReloader(manager));
            AsyncCommandHelper.wrap((ListenableFuture)future, (Supervisor)this.worldGuard.getSupervisor(), (Actor)sender, (ExceptionConverter)this.worldGuard.getExceptionConverter()).forRegionDataLoad(world, false);
        } else {
            ArrayList<RegionManager> managers = new ArrayList<RegionManager>();
            for (World w : WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getWorlds()) {
                RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(w);
                if (manager == null) continue;
                managers.add(manager);
            }
            ListenableFuture future = WorldGuard.getInstance().getExecutorService().submit((Callable)new RegionManagerReloader(managers));
            AsyncCommandHelper.wrap((ListenableFuture)future, (Supervisor)this.worldGuard.getSupervisor(), (Actor)sender, (ExceptionConverter)this.worldGuard.getExceptionConverter()).registerWithSupervisor("Loading regions for all worlds").sendMessageAfterDelay("(Please wait... loading region data for all worlds...)").thenRespondWith("Successfully load the region data for all worlds.", "Failed to load regions for all worlds");
        }
    }

    @Command(aliases={"save", "write"}, usage="[world]", desc="Re-save regions to file", flags="w:")
    public void save(CommandContext args, Actor sender) throws CommandException {
        RegionCommands.warnAboutSaveFailures(sender);
        World world = null;
        try {
            world = RegionCommands.checkWorld(args, sender, 'w');
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        if (!RegionCommands.getPermissionModel(sender).mayForceSaveRegions()) {
            throw new CommandPermissionsException();
        }
        if (world != null) {
            RegionManager manager = RegionCommands.checkRegionManager(world);
            if (manager == null) {
                throw new CommandException("No region manager exists for world '" + world.getName() + "'.");
            }
            ListenableFuture future = WorldGuard.getInstance().getExecutorService().submit((Callable)new RegionManagerSaver(manager));
            AsyncCommandHelper.wrap((ListenableFuture)future, (Supervisor)this.worldGuard.getSupervisor(), (Actor)sender, (ExceptionConverter)this.worldGuard.getExceptionConverter()).forRegionDataSave(world, false);
        } else {
            ArrayList<RegionManager> managers = new ArrayList<RegionManager>();
            for (World w : WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getWorlds()) {
                RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(w);
                if (manager == null) continue;
                managers.add(manager);
            }
            ListenableFuture future = WorldGuard.getInstance().getExecutorService().submit((Callable)new RegionManagerSaver(managers));
            AsyncCommandHelper.wrap((ListenableFuture)future, (Supervisor)this.worldGuard.getSupervisor(), (Actor)sender, (ExceptionConverter)this.worldGuard.getExceptionConverter()).registerWithSupervisor("Saving regions for all worlds").sendMessageAfterDelay("(Please wait... saving region data for all worlds...)").thenRespondWith("Successfully saved the region data for all worlds.", "Failed to save regions for all worlds");
        }
    }

    @Command(aliases={"migratedb"}, usage="<from> <to>", flags="y", desc="Migrate from one Protection Database to another.", min=2, max=2)
    public void migrateDB(CommandContext args, Actor sender) throws CommandException {
        if (!RegionCommands.getPermissionModel(sender).mayMigrateRegionStore()) {
            throw new CommandPermissionsException();
        }
        DriverType from = Enums.findFuzzyByValue(DriverType.class, args.getString(0));
        DriverType to = Enums.findFuzzyByValue(DriverType.class, args.getString(1));
        if (from == null) {
            throw new CommandException("The value of 'from' is not a recognized type of region data database.");
        }
        if (to == null) {
            throw new CommandException("The value of 'to' is not a recognized type of region region data database.");
        }
        if (from.equals((Object)to)) {
            throw new CommandException("It is not possible to migrate between the same types of region data databases.");
        }
        if (!args.hasFlag('y')) {
            throw new CommandException("This command is potentially dangerous.\nPlease ensure you have made a backup of your data, and then re-enter the command with -y tacked on at the end to proceed.");
        }
        ConfigurationManager config = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        RegionDriver fromDriver = config.regionStoreDriverMap.get((Object)from);
        RegionDriver toDriver = config.regionStoreDriverMap.get((Object)to);
        if (fromDriver == null) {
            throw new CommandException("The driver specified as 'from' does not seem to be supported in your version of WorldGuard.");
        }
        if (toDriver == null) {
            throw new CommandException("The driver specified as 'to' does not seem to be supported in your version of WorldGuard.");
        }
        DriverMigration migration = new DriverMigration(fromDriver, toDriver, WorldGuard.getInstance().getFlagRegistry());
        LoggerToChatHandler handler = null;
        Logger minecraftLogger = null;
        if (sender instanceof LocalPlayer) {
            handler = new LoggerToChatHandler(sender);
            handler.setLevel(Level.ALL);
            minecraftLogger = Logger.getLogger("com.sk89q.worldguard");
            minecraftLogger.addHandler(handler);
        }
        try {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            sender.print("Now performing migration... this may take a while.");
            container.migrate(migration);
            sender.print("Migration complete! This only migrated the data. If you already changed your settings to use the target driver, then WorldGuard is now using the new data. If not, you have to adjust your configuration to use the new driver and then restart your server.");
        }
        catch (MigrationException e) {
            log.log(Level.WARNING, "Failed to migrate", e);
            throw new CommandException("Error encountered while migrating: " + e.getMessage());
        }
        finally {
            if (minecraftLogger != null) {
                minecraftLogger.removeHandler(handler);
            }
        }
    }

    @Command(aliases={"migrateuuid"}, desc="Migrate loaded databases to use UUIDs", max=0)
    public void migrateUuid(CommandContext args, Actor sender) throws CommandException {
        if (!RegionCommands.getPermissionModel(sender).mayMigrateRegionNames()) {
            throw new CommandPermissionsException();
        }
        LoggerToChatHandler handler = null;
        Logger minecraftLogger = null;
        if (sender instanceof LocalPlayer) {
            handler = new LoggerToChatHandler(sender);
            handler.setLevel(Level.ALL);
            minecraftLogger = Logger.getLogger("com.sk89q.worldguard");
            minecraftLogger.addHandler(handler);
        }
        try {
            ConfigurationManager config = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            RegionDriver driver = container.getDriver();
            UUIDMigration migration = new UUIDMigration(driver, WorldGuard.getInstance().getProfileService(), WorldGuard.getInstance().getFlagRegistry());
            migration.setKeepUnresolvedNames(config.keepUnresolvedNames);
            sender.print("Now performing migration... this may take a while.");
            container.migrate(migration);
            sender.print("Migration complete!");
        }
        catch (MigrationException e) {
            log.log(Level.WARNING, "Failed to migrate", e);
            throw new CommandException("Error encountered while migrating: " + e.getMessage());
        }
        finally {
            if (minecraftLogger != null) {
                minecraftLogger.removeHandler(handler);
            }
        }
    }

    @Command(aliases={"teleport", "tp"}, usage="<id>", flags="s", desc="Teleports you to the location associated with the region.", min=1, max=1)
    public void teleport(CommandContext args, Actor sender) throws CommandException {
        Location teleportLocation;
        LocalPlayer player = this.worldGuard.checkPlayer(sender);
        RegionManager regionManager = RegionCommands.checkRegionManager(player.getWorld());
        ProtectedRegion existing = RegionCommands.checkExistingRegion(regionManager, args.getString(0), false);
        if (!RegionCommands.getPermissionModel((Actor)player).mayTeleportTo(existing)) {
            throw new CommandPermissionsException();
        }
        if (args.hasFlag('s')) {
            teleportLocation = (Location)existing.getFlag(Flags.SPAWN_LOC);
            if (teleportLocation == null) {
                throw new CommandException("The region has no spawn point associated.");
            }
        } else {
            teleportLocation = (Location)existing.getFlag(Flags.TELE_LOC);
            if (teleportLocation == null) {
                throw new CommandException("The region has no teleport point associated.");
            }
        }
        player.setLocation(teleportLocation);
        sender.print("Teleported you to the region '" + existing.getId() + "'.");
    }
}

