/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.commands.region;

import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.formatting.Style;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.RegionGroupFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.util.profile.cache.ProfileCache;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class RegionPrintoutBuilder
implements Callable<String> {
    private final ProtectedRegion region;
    @Nullable
    private final ProfileCache cache;
    private final StringBuilder builder = new StringBuilder();

    public RegionPrintoutBuilder(ProtectedRegion region, @Nullable ProfileCache cache) {
        this.region = region;
        this.cache = cache;
    }

    private void newLine() {
        this.builder.append("\n");
    }

    public void appendBasics() {
        this.builder.append(Style.BLUE);
        this.builder.append("Region: ");
        this.builder.append(Style.YELLOW);
        this.builder.append(this.region.getId());
        this.builder.append(Style.GRAY);
        this.builder.append(" (type=");
        this.builder.append(this.region.getType().getName());
        this.builder.append(Style.GRAY);
        this.builder.append(", priority=");
        this.builder.append(this.region.getPriority());
        this.builder.append(")");
        this.newLine();
    }

    public void appendFlags() {
        this.builder.append(Style.BLUE);
        this.builder.append("Flags: ");
        this.appendFlagsList(true);
        this.newLine();
    }

    public void appendFlagsList(boolean useColors) {
        boolean hasFlags = false;
        for (Flag flag : WorldGuard.getInstance().getFlagRegistry()) {
            Object val = this.region.getFlag(flag);
            Object group = null;
            if (val == null) continue;
            if (hasFlags) {
                this.builder.append(", ");
            } else if (useColors) {
                this.builder.append(Style.YELLOW);
            }
            RegionGroupFlag groupFlag = flag.getRegionGroupFlag();
            if (groupFlag != null) {
                group = this.region.getFlag(groupFlag);
            }
            if (group == null) {
                this.builder.append(flag.getName()).append(": ").append(Style.stripColor((String)String.valueOf(val)));
            } else {
                this.builder.append(flag.getName()).append(" -g ").append((Object)group).append(": ").append(Style.stripColor((String)String.valueOf(val)));
            }
            hasFlags = true;
        }
        if (!hasFlags) {
            if (useColors) {
                this.builder.append(Style.RED);
            }
            this.builder.append("(none)");
        }
    }

    public void appendParents() {
        this.appendParentTree(true);
    }

    public void appendParentTree(boolean useColors) {
        if (this.region.getParent() == null) {
            return;
        }
        ArrayList<ProtectedRegion> inheritance = new ArrayList<ProtectedRegion>();
        ProtectedRegion r = this.region;
        inheritance.add(r);
        while (r.getParent() != null) {
            r = r.getParent();
            inheritance.add(r);
        }
        ListIterator it = inheritance.listIterator(inheritance.size());
        int indent = 0;
        while (it.hasPrevious()) {
            ProtectedRegion cur = (ProtectedRegion)it.previous();
            if (useColors) {
                this.builder.append(Style.GREEN);
            }
            if (indent != 0) {
                for (int i = 0; i < indent; ++i) {
                    this.builder.append("  ");
                }
                this.builder.append("\u2517");
            }
            this.builder.append(cur.getId());
            if (!cur.equals(this.region)) {
                if (useColors) {
                    this.builder.append(Style.GRAY);
                }
                this.builder.append(" (parent, priority=").append(cur.getPriority()).append(")");
            }
            ++indent;
            this.newLine();
        }
    }

    public void appendDomain() {
        this.builder.append(Style.BLUE);
        this.builder.append("Owners: ");
        this.addDomainString(this.region.getOwners());
        this.newLine();
        this.builder.append(Style.BLUE);
        this.builder.append("Members: ");
        this.addDomainString(this.region.getMembers());
        this.newLine();
    }

    private void addDomainString(DefaultDomain domain) {
        if (domain.size() != 0) {
            this.builder.append(Style.YELLOW);
            this.builder.append(domain.toUserFriendlyString(this.cache));
        } else {
            this.builder.append(Style.RED);
            this.builder.append("(none)");
        }
    }

    public void appendBounds() {
        BlockVector3 min = this.region.getMinimumPoint();
        BlockVector3 max = this.region.getMaximumPoint();
        this.builder.append(Style.BLUE);
        this.builder.append("Bounds:");
        this.builder.append(Style.YELLOW);
        this.builder.append(" (").append(min.getBlockX()).append(",").append(min.getBlockY()).append(",").append(min.getBlockZ()).append(")");
        this.builder.append(" -> (").append(max.getBlockX()).append(",").append(max.getBlockY()).append(",").append(max.getBlockZ()).append(")");
        this.newLine();
    }

    private void appendRegionInformation() {
        this.builder.append(Style.GRAY);
        this.builder.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        this.builder.append(" Region Info ");
        this.builder.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        this.newLine();
        this.appendBasics();
        this.appendFlags();
        this.appendParents();
        this.appendDomain();
        this.appendBounds();
        if (this.cache != null) {
            this.builder.append(Style.GRAY).append("Any names suffixed by * are 'last seen names' and may not be up to date.");
            this.newLine();
        }
    }

    @Override
    public String call() throws Exception {
        this.appendRegionInformation();
        return this.builder.toString();
    }

    public void send(Actor sender) {
        sender.printRaw(this.toString());
    }

    public StringBuilder append(boolean b) {
        return this.builder.append(b);
    }

    public StringBuilder append(char c) {
        return this.builder.append(c);
    }

    public StringBuilder append(char[] str, int offset, int len) {
        return this.builder.append(str, offset, len);
    }

    public StringBuilder append(char[] str) {
        return this.builder.append(str);
    }

    public StringBuilder append(CharSequence s, int start, int end) {
        return this.builder.append(s, start, end);
    }

    public StringBuilder append(CharSequence s) {
        return this.builder.append(s);
    }

    public StringBuilder append(double d) {
        return this.builder.append(d);
    }

    public StringBuilder append(float f) {
        return this.builder.append(f);
    }

    public StringBuilder append(int i) {
        return this.builder.append(i);
    }

    public StringBuilder append(long lng) {
        return this.builder.append(lng);
    }

    public StringBuilder append(Object obj) {
        return this.builder.append(obj);
    }

    public StringBuilder append(String str) {
        return this.builder.append(str);
    }

    public StringBuilder append(StringBuffer sb) {
        return this.builder.append(sb);
    }

    public StringBuilder appendCodePoint(int codePoint) {
        return this.builder.appendCodePoint(codePoint);
    }

    public String toString() {
        return this.builder.toString().trim();
    }
}

