/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.google.common.collect.Sets;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.commands.CommandUtils;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class GreetingFlag
extends Handler {
    public static final Factory FACTORY = new Factory();
    private Set<String> lastMessageStack = Collections.emptySet();

    public GreetingFlag(Session session) {
        super(session);
    }

    @Override
    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        Collection<String> messages = toSet.queryAllValues(player, Flags.GREET_MESSAGE);
        for (String message : messages) {
            if (this.lastMessageStack.contains(message)) continue;
            String effective = CommandUtils.replaceColorMacros(message);
            effective = WorldGuard.getInstance().getPlatform().getMatcher().replaceMacros((Actor)player, effective);
            for (String mess : effective.replaceAll("\\\\n", "\n").split("\\n")) {
                player.printRaw(mess);
            }
        }
        this.lastMessageStack = Sets.newHashSet(messages);
        if (!this.lastMessageStack.isEmpty()) {
            for (ProtectedRegion region : toSet) {
                String message = (String)region.getFlag(Flags.GREET_MESSAGE);
                if (message == null) continue;
                this.lastMessageStack.add(message);
            }
        }
        return true;
    }

    public static class Factory
    extends Handler.Factory<GreetingFlag> {
        @Override
        public GreetingFlag create(Session session) {
            return new GreetingFlag(session);
        }
    }
}

