/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.util.formatting.Style;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.util.Entities;

public class ToggleCommands {
    private final WorldGuard worldGuard;

    public ToggleCommands(WorldGuard worldGuard) {
        this.worldGuard = worldGuard;
    }

    @Command(aliases={"stopfire"}, usage="[<world>]", desc="Disables all fire spread temporarily", max=1)
    @CommandPermissions(value={"worldguard.fire-toggle.stop"})
    public void stopFire(CommandContext args, Actor sender) throws CommandException {
        World world = args.argsLength() == 0 ? this.worldGuard.checkPlayer(sender).getWorld() : this.worldGuard.getPlatform().getMatcher().matchWorld(sender, args.getString(0));
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(world);
        if (!wcfg.fireSpreadDisableToggle) {
            this.worldGuard.getPlatform().broadcastNotification(Style.YELLOW + "Fire spread has been globally disabled for '" + world.getName() + "' by " + sender.getDisplayName() + ".");
        } else {
            sender.print("Fire spread was already globally disabled.");
        }
        wcfg.fireSpreadDisableToggle = true;
    }

    @Command(aliases={"allowfire"}, usage="[<world>]", desc="Allows all fire spread temporarily", max=1)
    @CommandPermissions(value={"worldguard.fire-toggle.stop"})
    public void allowFire(CommandContext args, Actor sender) throws CommandException {
        World world = args.argsLength() == 0 ? this.worldGuard.checkPlayer(sender).getWorld() : this.worldGuard.getPlatform().getMatcher().matchWorld(sender, args.getString(0));
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(world);
        if (wcfg.fireSpreadDisableToggle) {
            this.worldGuard.getPlatform().broadcastNotification(Style.YELLOW + "Fire spread has been globally for '" + world.getName() + "' re-enabled by " + sender.getDisplayName() + ".");
        } else {
            sender.print("Fire spread was already globally enabled.");
        }
        wcfg.fireSpreadDisableToggle = false;
    }

    @Command(aliases={"halt-activity", "stoplag", "haltactivity"}, desc="Attempts to cease as much activity in order to stop lag", flags="cis", max=0)
    @CommandPermissions(value={"worldguard.halt-activity"})
    public void stopLag(CommandContext args, Actor sender) throws CommandException {
        ConfigurationManager configManager = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        if (args.hasFlag('i')) {
            if (configManager.activityHaltToggle) {
                sender.print("ALL intensive server activity is not allowed.");
            } else {
                sender.print("ALL intensive server activity is allowed.");
            }
        } else {
            boolean bl = configManager.activityHaltToggle = !args.hasFlag('c');
            if (configManager.activityHaltToggle) {
                if (!(sender instanceof LocalPlayer)) {
                    sender.print("ALL intensive server activity halted.");
                }
                if (!args.hasFlag('s')) {
                    this.worldGuard.getPlatform().broadcastNotification(Style.YELLOW + "ALL intensive server activity halted by " + sender.getDisplayName() + ".");
                } else {
                    sender.print("(Silent) ALL intensive server activity halted by " + sender.getDisplayName() + ".");
                }
                for (World world : WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getWorlds()) {
                    int removed = 0;
                    for (Entity entity : world.getEntities()) {
                        if (!Entities.isIntensiveEntity(entity)) continue;
                        entity.remove();
                        ++removed;
                    }
                    if (removed <= 10) continue;
                    sender.printRaw("" + removed + " entities (>10) auto-removed from " + world.getName());
                }
            } else if (!args.hasFlag('s')) {
                this.worldGuard.getPlatform().broadcastNotification(Style.YELLOW + "ALL intensive server activity is now allowed.");
                if (!(sender instanceof LocalPlayer)) {
                    sender.print("ALL intensive server activity is now allowed.");
                }
            } else {
                sender.print("(Silent) ALL intensive server activity is now allowed.");
            }
        }
    }
}

