/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.blacklist.target.BlockTarget;
import com.sk89q.worldguard.blacklist.target.ItemTarget;
import com.sk89q.worldguard.blacklist.target.Target;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.ItemStack;

public class BukkitUtil {
    private BukkitUtil() {
    }

    public static boolean isWaterPotion(ItemStack item) {
        return (item.getDurability() & 0x3F) == 0;
    }

    public static int getPotionEffectBits(ItemStack item) {
        return item.getDurability() & 0x3F;
    }

    public static String replaceColorMacros(String str) {
        str = str.replace("&r", ChatColor.RED.toString());
        str = str.replace("&R", ChatColor.DARK_RED.toString());
        str = str.replace("&y", ChatColor.YELLOW.toString());
        str = str.replace("&Y", ChatColor.GOLD.toString());
        str = str.replace("&g", ChatColor.GREEN.toString());
        str = str.replace("&G", ChatColor.DARK_GREEN.toString());
        str = str.replace("&c", ChatColor.AQUA.toString());
        str = str.replace("&C", ChatColor.DARK_AQUA.toString());
        str = str.replace("&b", ChatColor.BLUE.toString());
        str = str.replace("&B", ChatColor.DARK_BLUE.toString());
        str = str.replace("&p", ChatColor.LIGHT_PURPLE.toString());
        str = str.replace("&P", ChatColor.DARK_PURPLE.toString());
        str = str.replace("&0", ChatColor.BLACK.toString());
        str = str.replace("&1", ChatColor.DARK_GRAY.toString());
        str = str.replace("&2", ChatColor.GRAY.toString());
        str = str.replace("&w", ChatColor.WHITE.toString());
        str = str.replace("&k", ChatColor.MAGIC.toString());
        str = str.replace("&l", ChatColor.BOLD.toString());
        str = str.replace("&m", ChatColor.STRIKETHROUGH.toString());
        str = str.replace("&n", ChatColor.UNDERLINE.toString());
        str = str.replace("&o", ChatColor.ITALIC.toString());
        str = str.replace("&x", ChatColor.RESET.toString());
        return str;
    }

    public static boolean isIntensiveEntity(Entity entity) {
        return entity instanceof Item || entity instanceof TNTPrimed || entity instanceof ExperienceOrb || entity instanceof FallingBlock || entity instanceof LivingEntity && !(entity instanceof Tameable) && !(entity instanceof Player) && !(entity instanceof ArmorStand);
    }

    public static Target createTarget(Block block) {
        Preconditions.checkNotNull((Object)block);
        Preconditions.checkNotNull((Object)block.getType());
        return new BlockTarget(BukkitAdapter.asBlockType((Material)block.getType()));
    }

    public static Target createTarget(ItemStack item) {
        Preconditions.checkNotNull((Object)item);
        Preconditions.checkNotNull((Object)item.getType());
        return BukkitUtil.createTarget(item.getType());
    }

    public static Target createTarget(Material material) {
        Preconditions.checkNotNull((Object)material);
        if (material.isBlock()) {
            return new BlockTarget(BukkitAdapter.asBlockType((Material)material));
        }
        return new ItemTarget(BukkitAdapter.asItemType((Material)material));
    }
}

