/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitConfigurationManager;
import com.sk89q.worldguard.bukkit.BukkitRegionContainer;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.protection.events.flags.FlagContextCreateEvent;
import com.sk89q.worldguard.bukkit.session.BukkitSessionManager;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.session.SessionManager;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BukkitWorldGuardPlatform
implements WorldGuardPlatform {
    private SessionManager sessionManager;
    private BukkitConfigurationManager configuration;
    private BukkitRegionContainer regionContainer;

    public void notifyFlagContextCreate(FlagContext.FlagContextBuilder flagContextBuilder) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new FlagContextCreateEvent(flagContextBuilder));
    }

    public BukkitConfigurationManager getGlobalStateManager() {
        return this.configuration;
    }

    public World getWorldByName(String worldName) {
        return BukkitAdapter.adapt((org.bukkit.World)Bukkit.getServer().getWorld(worldName));
    }

    public String replaceColorMacros(String string) {
        return BukkitUtil.replaceColorMacros(string);
    }

    public String replaceMacros(Actor sender, String message) {
        Collection online = Bukkit.getServer().getOnlinePlayers();
        message = message.replace("%name%", sender.getName());
        message = message.replace("%id%", sender.getUniqueId().toString());
        message = message.replace("%online%", String.valueOf(online.size()));
        if (sender instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)sender;
            World world = (World)player.getExtent();
            message = message.replace("%world%", world.getName());
            message = message.replace("%health%", String.valueOf(player.getHealth()));
        }
        return message;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void broadcastNotification(String message) {
        Bukkit.broadcast((String)message, (String)"worldguard.notify");
        Set subs = Bukkit.getPluginManager().getPermissionSubscriptions("worldguard.notify");
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (subs.contains(player) && player.hasPermission("worldguard.notify") || !WorldGuardPlugin.inst().hasPermission((CommandSender)player, "worldguard.notify")) continue;
            player.sendMessage(message);
        }
        WorldGuard.logger.info(message);
    }

    public void load() {
        this.sessionManager = new BukkitSessionManager(WorldGuardPlugin.inst());
        this.configuration = new BukkitConfigurationManager(WorldGuardPlugin.inst());
        this.configuration.load();
        this.regionContainer = new BukkitRegionContainer(WorldGuardPlugin.inst());
        this.regionContainer.initialize();
    }

    public void unload() {
        this.configuration.unload();
        this.regionContainer.unload();
    }

    public RegionContainer getRegionContainer() {
        return this.regionContainer;
    }

    public GameMode getDefaultGameMode() {
        return GameModes.get((String)Bukkit.getServer().getDefaultGameMode().name().toLowerCase());
    }

    public Path getConfigDir() {
        return WorldGuardPlugin.inst().getDataFolder().toPath();
    }
}

