/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcmultipart.MCMultiPartMod;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.block.TileCoverable;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.client.multipart.ICustomHighlightPart;
import mcmultipart.client.multipart.MultipartStateMapper;
import mcmultipart.microblock.IMicroblockContainerTile;
import mcmultipart.microblock.MicroblockContainer;
import mcmultipart.multipart.MultipartContainer;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCoverable
extends Block
implements ITileEntityProvider {
    private AxisAlignedBB bounds = FULL_BLOCK_AABB;
    private IMicroblockContainerTile brokenTile = null;
    private boolean harvestingWrapper = false;

    public BlockCoverable(Material material) {
        super(material);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return this.createNewTileEntityDefault(worldIn, meta);
    }

    public <T extends TileEntity> T createNewTileEntityDefault(World worldIn, int meta) {
        return (T)new TileCoverable();
    }

    protected IMicroblockContainerTile getMicroblockTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        return tile instanceof IMicroblockContainerTile ? (IMicroblockContainerTile)tile : null;
    }

    public final RayTraceResult collisionRayTrace(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        RayTraceUtils.AdvancedRayTraceResultPart result = tile != null ? tile.getMicroblockContainer().getPartContainer().collisionRayTrace(start, end) : null;
        RayTraceResult hit = this.collisionRayTraceDefault(state, world, pos, start, end);
        if (result == null || hit != null && hit.hitVec.squareDistanceTo(start) < result.squareDistanceTo(start)) {
            this.bounds = this.getSelectedBoundingBoxDefault(state, world, pos).offset((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
            return hit;
        }
        this.bounds = result.bounds;
        return result.hit;
    }

    public RayTraceResult collisionRayTraceDefault(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return super.collisionRayTrace(state, world, pos, start, end);
    }

    public final AxisAlignedBB getSelectedBoundingBox(IBlockState state, World worldIn, BlockPos pos) {
        return this.bounds.offset(pos);
    }

    public AxisAlignedBB getSelectedBoundingBoxDefault(IBlockState state, World worldIn, BlockPos pos) {
        return super.getSelectedBoundingBox(state, worldIn, pos);
    }

    public final void addCollisionBoxToList(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity collidingEntity) {
        this.addCollisionBoxToListDefault(state, world, pos, entityBox, collidingBoxes, collidingEntity);
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        AxisAlignedBB box = entityBox.offset((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
        tile.getMicroblockContainer().getPartContainer().addCollisionBoxes(box, list, collidingEntity);
        for (AxisAlignedBB aabb : list) {
            collidingBoxes.add(aabb.offset(pos));
        }
    }

    public void addCollisionBoxToListDefault(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        super.addCollisionBoxToList(state, worldIn, pos, entityBox, collidingBoxes, entityIn);
    }

    public final int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        return Math.max(tile != null ? tile.getMicroblockContainer().getPartContainer().getLightValue() : 0, this.getLightValueDefault(state, world, pos));
    }

    public int getLightValueDefault(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getLightValue(state, world, pos);
    }

    public final ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (target instanceof PartMOP) {
            IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
            return tile != null ? tile.getMicroblockContainer().getPartContainer().getPickBlock(player, (PartMOP)target) : null;
        }
        return this.getPickBlockDefault(state, target, world, pos, player);
    }

    public ItemStack getPickBlockDefault(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return super.getPickBlock(state, target, world, pos, player);
    }

    public final void harvestBlock(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        this.brokenTile = te instanceof IMicroblockContainerTile ? (IMicroblockContainerTile)te : null;
        this.harvestBlockDefault(world, player, pos, state, te, stack);
        this.brokenTile = null;
    }

    public void harvestBlockDefault(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.harvestBlock(worldIn, player, pos, state, te, stack);
    }

    public final List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.harvestingWrapper) {
            return this.getDropsDefault(world, pos, state, fortune);
        }
        IMicroblockContainerTile brokenTile = this.getMicroblockTile(world, pos);
        if (brokenTile == null) {
            brokenTile = this.brokenTile;
        }
        if (brokenTile == null) {
            return this.getDropsDefault(world, pos, state, fortune);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.addAll(this.getDropsDefault(world, pos, state, fortune));
        return drops;
    }

    public List<ItemStack> getDropsDefault(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return super.getDrops(world, pos, state, fortune);
    }

    public final boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        MultipartContainer container;
        RayTraceResult hit = this.reTraceAll(world, pos, player);
        if (hit instanceof PartMOP) {
            IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
            if (tile != null) {
                tile.getMicroblockContainer().getPartContainer().harvest(player, (PartMOP)hit);
            }
            return false;
        }
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        MultipartContainer multipartContainer = container = tile != null ? tile.getMicroblockContainer().getPartContainer() : null;
        if (container.getParts().isEmpty()) {
            return this.removedByPlayerDefault(state, world, pos, player, willHarvest);
        }
        if (!this.removedByPlayerDefault(state, world, pos, player, willHarvest)) {
            return false;
        }
        world.removeTileEntity(pos);
        if (!world.setBlockState(pos, MCMultiPartMod.multipart.getDefaultState(), 0)) {
            return false;
        }
        world.removeTileEntity(pos);
        world.setTileEntity(pos, (TileEntity)new TileMultipartContainer(container));
        world.notifyBlockUpdate(pos, state, MCMultiPartMod.multipart.getDefaultState(), 0);
        this.harvestingWrapper = true;
        if (!player.capabilities.isCreativeMode) {
            this.harvestBlock(world, player, pos, world.getBlockState(pos), world.getTileEntity(pos), player.getActiveItemStack());
        }
        this.harvestingWrapper = false;
        return false;
    }

    public boolean removedByPlayerDefault(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public final float getPlayerRelativeBlockHardness(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        RayTraceResult hit = this.reTraceAll(world, pos, player);
        if (hit instanceof PartMOP) {
            IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
            return tile != null ? tile.getMicroblockContainer().getPartContainer().getHardness(player, (PartMOP)hit) : 0.0f;
        }
        return this.getPlayerRelativeBlockHardnessDefault(state, player, world, pos);
    }

    public float getPlayerRelativeBlockHardnessDefault(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        return super.getPlayerRelativeBlockHardness(state, player, world, pos);
    }

    public final boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult hit = this.reTraceAll(world, pos, player);
        if (hit instanceof PartMOP) {
            IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
            return tile != null ? tile.getMicroblockContainer().getPartContainer().onActivated(player, hand, heldItem, (PartMOP)hit) : false;
        }
        return this.onBlockActivatedDefault(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public boolean onBlockActivatedDefault(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.onBlockActivated(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public final void onBlockClicked(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult hit = this.reTraceAll(world, pos, player);
        if (hit instanceof PartMOP) {
            IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
            if (tile != null) {
                tile.getMicroblockContainer().getPartContainer().onClicked(player, (PartMOP)hit);
            }
        } else {
            this.onBlockClickedDefault(world, pos, player);
        }
    }

    public void onBlockClickedDefault(World world, BlockPos pos, EntityPlayer player) {
        super.onBlockClicked(world, pos, player);
    }

    public final void neighborChanged(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.getMicroblockContainer().getPartContainer().onNeighborBlockChange(neighborBlock);
        }
        this.onNeighborBlockChangeDefault(world, pos, state, neighborBlock);
    }

    public void onNeighborBlockChangeDefault(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.neighborChanged(state, world, pos, neighborBlock);
    }

    public final void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        if (tile != null) {
            tile.getMicroblockContainer().getPartContainer().onNeighborTileChange(EnumFacing.getFacingFromVector((float)(neighbor.getX() - pos.getX()), (float)(neighbor.getY() - pos.getY()), (float)(neighbor.getZ() - pos.getZ())));
        }
        this.onNeighborChangeDefault(world, pos, neighbor);
    }

    public void onNeighborChangeDefault(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
    }

    public final void onEntityWalk(World world, BlockPos pos, Entity entity) {
        this.onEntityWalkDefault(world, pos, entity);
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.getMicroblockContainer().getPartContainer().onEntityStanding(entity);
    }

    public void onEntityWalkDefault(World worldIn, BlockPos pos, Entity entityIn) {
        super.onEntityWalk(worldIn, pos, entityIn);
    }

    public final void onEntityCollidedWithBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.onEntityCollidedWithBlockDefault(world, pos, state, entity);
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.getMicroblockContainer().getPartContainer().onEntityCollided(entity);
    }

    public void onEntityCollidedWithBlockDefault(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.onEntityCollidedWithBlock(worldIn, pos, state, entityIn);
    }

    public final Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB aabb, Material material) {
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        Boolean def = this.isAABBInsideMaterialDefault(world, pos, aabb, material);
        if (tile == null) {
            return def;
        }
        Boolean is = tile.getMicroblockContainer().getPartContainer().isAABBInsideMaterial(aabb, material);
        if (def != null && def.booleanValue() || is != null && is.booleanValue()) {
            return true;
        }
        if (def != null && !def.booleanValue() || is != null && !is.booleanValue()) {
            return false;
        }
        return null;
    }

    public Boolean isAABBInsideMaterialDefault(World world, BlockPos pos, AxisAlignedBB boundingBox, Material materialIn) {
        return super.isAABBInsideMaterial(world, pos, boundingBox, materialIn);
    }

    public final Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, double yToTest, Material material, boolean testingHead) {
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        Boolean def = this.isEntityInsideMaterialDefault(world, pos, state, entity, yToTest, material, testingHead);
        if (tile == null) {
            return def;
        }
        Boolean is = tile.getMicroblockContainer().getPartContainer().isEntityInsideMaterial(entity, yToTest, material, testingHead);
        if (def != null && def.booleanValue() || is != null && is.booleanValue()) {
            return true;
        }
        if (def != null && !def.booleanValue() || is != null && !is.booleanValue()) {
            return false;
        }
        return null;
    }

    public Boolean isEntityInsideMaterialDefault(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        return super.isEntityInsideMaterial(world, blockpos, iblockstate, entity, yToTest, materialIn, testingHead);
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public final boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        MicroblockContainer container;
        if (side == null) {
            return false;
        }
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        MicroblockContainer microblockContainer = container = tile != null ? tile.getMicroblockContainer() : null;
        if (container.getPartContainer().canConnectRedstone(side)) {
            return true;
        }
        return this.canConnectRedstoneDefault(state, world, pos, side, container);
    }

    public boolean canConnectRedstoneDefault(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side, MicroblockContainer partContainer) {
        return super.canConnectRedstone(state, world, pos, side);
    }

    public final int getWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        MicroblockContainer container;
        if (side == null) {
            return 0;
        }
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        MicroblockContainer microblockContainer = container = tile != null ? tile.getMicroblockContainer() : null;
        if (container == null) {
            return this.getWeakPowerDefault(state, world, pos, side, null);
        }
        return Math.max(container.getPartContainer().getWeakSignal(side), this.getWeakPowerDefault(state, world, pos, side, container));
    }

    public int getWeakPowerDefault(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side, MicroblockContainer partContainer) {
        return super.getWeakPower(state, world, pos, side);
    }

    public final int getStrongPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        MicroblockContainer container;
        if (side == null) {
            return 0;
        }
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        MicroblockContainer microblockContainer = container = tile != null ? tile.getMicroblockContainer() : null;
        if (container == null) {
            return this.getStrongPowerDefault(state, world, pos, side, null);
        }
        return Math.max(container.getPartContainer().getStrongSignal(side), this.getStrongPowerDefault(state, world, pos, side, container));
    }

    public int getStrongPowerDefault(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side, MicroblockContainer partContainer) {
        return super.getStrongPower(state, world, pos, side);
    }

    public final boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        MicroblockContainer container;
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        MicroblockContainer microblockContainer = container = tile != null ? tile.getMicroblockContainer() : null;
        if (container == null) {
            return false;
        }
        return container.getPartContainer().isSideSolid(side) || this.isSideSolidDefault(state, world, pos, side);
    }

    public boolean isSideSolidDefault(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return super.isSideSolid(state, world, pos, side);
    }

    public final boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        MicroblockContainer container;
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        MicroblockContainer microblockContainer = container = tile != null ? tile.getMicroblockContainer() : null;
        if (container == null) {
            return false;
        }
        return container.getPartContainer().canPlaceTorchOnTop() || this.canPlaceTorchOnTopDefault(state, world, pos);
    }

    public boolean canPlaceTorchOnTopDefault(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.canPlaceTorchOnTop(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public final void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        MicroblockContainer container;
        this.randomDisplayTickDefault(state, world, pos, rand);
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        MicroblockContainer microblockContainer = container = tile != null ? tile.getMicroblockContainer() : null;
        if (container != null) {
            container.getPartContainer().randomDisplayTick(rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTickDefault(IBlockState state, World world, BlockPos pos, Random rand) {
        super.randomDisplayTick(state, world, pos, rand);
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean addDestroyEffects(World world, BlockPos pos, ParticleManager particleManager) {
        PartMOP hit = this.reTrace(world, pos, MCMultiPartMod.proxy.getPlayer());
        if (hit != null) {
            TextureAtlasSprite icon;
            IBakedModel model;
            if (hit.partHit.addDestroyEffects(AdvancedParticleManager.getInstance(particleManager))) {
                return true;
            }
            ResourceLocation path = hit.partHit.getModelPath();
            IBlockState state = hit.partHit.getExtendedState(MultipartRegistry.getDefaultState(hit.partHit).getBaseState());
            IBakedModel iBakedModel = model = path == null ? null : Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getModel(new ModelResourceLocation(path, MultipartStateMapper.instance.getPropertyString((Map<IProperty<?>, Comparable<?>>)state.getProperties())));
            if (model != null && (icon = model.getParticleTexture()) != null) {
                AdvancedParticleManager.getInstance(particleManager).addBlockDestroyEffects(pos, icon);
                return true;
            }
            return true;
        }
        return this.addDestroyEffectsDefault(world, pos, particleManager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffectsDefault(World world, BlockPos pos, ParticleManager particleManager) {
        return super.addDestroyEffects(world, pos, particleManager);
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager particleManager) {
        PartMOP hit;
        PartMOP partMOP = hit = target instanceof PartMOP ? (PartMOP)target : null;
        if (hit != null) {
            TextureAtlasSprite icon;
            IBakedModel model;
            if (hit.partHit.addHitEffects(hit, AdvancedParticleManager.getInstance(particleManager))) {
                return true;
            }
            ResourceLocation path = hit.partHit.getModelPath();
            IBlockState partState = hit.partHit.getExtendedState(MultipartRegistry.getDefaultState(hit.partHit).getBaseState());
            IBakedModel iBakedModel = model = path == null ? null : Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getModel(new ModelResourceLocation(path, MultipartStateMapper.instance.getPropertyString((Map<IProperty<?>, Comparable<?>>)partState.getProperties())));
            if (model != null && (icon = model.getParticleTexture()) != null) {
                AdvancedParticleManager.getInstance(particleManager).addBlockHitEffects(target.getBlockPos(), hit, this.bounds, icon);
                return true;
            }
            return true;
        }
        return this.addHitEffectsDefault(state, world, target, particleManager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffectsDefault(IBlockState state, World world, RayTraceResult target, ParticleManager particleManager) {
        return super.addHitEffects(state, world, target, particleManager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    private PartMOP reTrace(World world, BlockPos pos, EntityPlayer player) {
        IMicroblockContainerTile tile = this.getMicroblockTile((IBlockAccess)world, pos);
        if (tile == null) {
            return null;
        }
        Vec3d start = RayTraceUtils.getStart(player);
        Vec3d end = RayTraceUtils.getEnd(player);
        RayTraceUtils.AdvancedRayTraceResultPart result = tile.getMicroblockContainer().getPartContainer().collisionRayTrace(start, end);
        return result == null ? null : (PartMOP)result.hit;
    }

    private RayTraceResult reTraceBlock(World world, BlockPos pos, EntityPlayer player) {
        Vec3d start = RayTraceUtils.getStart(player);
        Vec3d end = RayTraceUtils.getEnd(player);
        return this.collisionRayTraceDefault(world.getBlockState(pos), world, pos, start, end);
    }

    private RayTraceResult reTraceAll(World world, BlockPos pos, EntityPlayer player) {
        Vec3d start = RayTraceUtils.getStart(player);
        PartMOP partMOP = this.reTrace(world, pos, player);
        RayTraceResult blockMOP = this.reTraceBlock(world, pos, player);
        if (partMOP == null && blockMOP == null) {
            return null;
        }
        if (partMOP == null && blockMOP != null) {
            return blockMOP;
        }
        if (partMOP != null && blockMOP == null) {
            return partMOP;
        }
        if (partMOP.hitVec.squareDistanceTo(start) <= blockMOP.hitVec.squareDistanceTo(start)) {
            return partMOP;
        }
        return blockMOP;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isBlockNormalCube(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IMicroblockContainerTile tile = this.getMicroblockTile(world, pos);
        return ((IExtendedBlockState)state).withProperty(BlockMultipartContainer.PROPERTY_MULTIPART_CONTAINER, tile != null ? tile.getMicroblockContainer().getPartContainer().getExtendedStates(world, pos) : new ArrayList());
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[0], BlockMultipartContainer.UNLISTED_PROPERTIES);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean canRenderInLayerDefault(IBlockState state, BlockRenderLayer layer) {
        return this.canRenderInLayerDefault(layer);
    }

    @Deprecated
    public boolean canRenderInLayerDefault(BlockRenderLayer layer) {
        return super.canRenderInLayer(layer);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public final void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        PartMOP hit;
        PartMOP partMOP = hit = event.getTarget() instanceof PartMOP ? (PartMOP)event.getTarget() : null;
        if (hit != null) {
            GlStateManager.pushMatrix();
            BlockPos pos = hit.getBlockPos();
            EntityPlayer player = event.getPlayer();
            float partialTicks = event.getPartialTicks();
            double x = (double)pos.getX() - (player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)partialTicks);
            double y = (double)pos.getY() - (player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)partialTicks);
            double z = (double)pos.getZ() - (player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)partialTicks);
            GlStateManager.translate((double)x, (double)y, (double)z);
            if (hit.partHit instanceof ICustomHighlightPart && ((ICustomHighlightPart)hit.partHit).drawHighlight(hit, player, partialTicks)) {
                event.setCanceled(true);
            }
            GlStateManager.popMatrix();
        } else {
            this.onDrawBlockHighlightDefault(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDrawBlockHighlightDefault(DrawBlockHighlightEvent event) {
    }
}

