/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcmultipart.MCMultiPartMod;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.client.multipart.ICustomHighlightPart;
import mcmultipart.client.multipart.MultipartStateMapper;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.multipart.PartState;
import mcmultipart.property.PropertyMultipartStates;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BlockMultipartContainer
extends Block
implements ITileEntityProvider {
    private AxisAlignedBB bounds = FULL_BLOCK_AABB;
    private TileMultipartContainer brokenTile = null;
    public static final IProperty<Boolean> PROPERTY_TICKING = PropertyBool.create((String)"ticking");
    public static final IUnlistedProperty<List<PartState>> PROPERTY_MULTIPART_CONTAINER = new PropertyMultipartStates("multipart_container");
    static final IProperty<?>[] PROPERTIES = new IProperty[]{PROPERTY_TICKING};
    static final IUnlistedProperty<?>[] UNLISTED_PROPERTIES = new IUnlistedProperty[]{PROPERTY_MULTIPART_CONTAINER};

    public BlockMultipartContainer() {
        super(Material.GROUND);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setDefaultState(this.getDefaultState().withProperty(PROPERTY_TICKING, (Comparable)Boolean.valueOf(true)));
    }

    private TileMultipartContainer getMultipartTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        return tile instanceof TileMultipartContainer ? (TileMultipartContainer)tile : null;
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return meta == 1 ? new TileMultipartContainer() : new TileMultipartContainer.Ticking();
    }

    public RayTraceResult collisionRayTrace(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        if (state == null || world == null || pos == null || start == null || end == null) {
            return null;
        }
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return null;
        }
        RayTraceUtils.AdvancedRayTraceResultPart result = tile.getPartContainer().collisionRayTrace(start, end);
        if (result == null) {
            return null;
        }
        this.bounds = result.bounds;
        return result.hit;
    }

    public AxisAlignedBB getSelectedBoundingBox(IBlockState state, World world, BlockPos pos) {
        return this.bounds.offset(pos);
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity collidingEntity) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        AxisAlignedBB box = entityBox.offset((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
        tile.getPartContainer().addCollisionBoxes(box, list, collidingEntity);
        for (AxisAlignedBB aabb : list) {
            collidingBoxes.add(aabb.offset(pos));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return 0;
        }
        return tile.getPartContainer().getLightValue();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (target instanceof PartMOP) {
            TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
            if (tile == null) {
                return null;
            }
            return tile.getPartContainer().getPickBlock(player, (PartMOP)target);
        }
        return null;
    }

    public void harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        this.brokenTile = te instanceof TileMultipartContainer ? (TileMultipartContainer)te : null;
        super.harvestBlock(worldIn, player, pos, state, te, stack);
        this.brokenTile = null;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileMultipartContainer brokenTile = this.getMultipartTile(world, pos);
        if (brokenTile == null) {
            brokenTile = this.brokenTile;
        }
        if (brokenTile == null) {
            return Collections.emptyList();
        }
        return brokenTile.getPartContainer().getDrops();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        PartMOP hit = this.reTrace(world, pos, player);
        if (hit == null) {
            return false;
        }
        return tile.getPartContainer().harvest(player, hit) ? super.removedByPlayer(state, world, pos, player, willHarvest) : false;
    }

    public float getPlayerRelativeBlockHardness(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return 0.0f;
        }
        PartMOP hit = this.reTrace(world, pos, player);
        if (hit == null) {
            return 0.0f;
        }
        return tile.getPartContainer().getHardness(player, hit);
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        return tile.getPartContainer().onActivated(player, hand, heldItem, this.reTrace(world, pos, player));
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onClicked(player, this.reTrace(world, pos, player));
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onNeighborBlockChange(neighborBlock);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onNeighborTileChange(EnumFacing.getFacingFromVector((float)(neighbor.getX() - pos.getX()), (float)(neighbor.getY() - pos.getY()), (float)(neighbor.getZ() - pos.getZ())));
    }

    public void onEntityWalk(World world, BlockPos pos, Entity entity) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onEntityStanding(entity);
    }

    public void onEntityCollidedWithBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onEntityCollided(entity);
    }

    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB aabb, Material material) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return null;
        }
        return tile.getPartContainer().isAABBInsideMaterial(aabb, material);
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, double yToTest, Material material, boolean testingHead) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return null;
        }
        return tile.getPartContainer().isEntityInsideMaterial(entity, yToTest, material, testingHead);
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return false;
        }
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return false;
        }
        return tile.getPartContainer().canConnectRedstone(side.getOpposite());
    }

    public int getWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return 0;
        }
        return tile.getPartContainer().getWeakSignal(side.getOpposite());
    }

    public int getStrongPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return 0;
        }
        return tile.getPartContainer().getStrongSignal(side.getOpposite());
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return false;
        }
        return tile.getPartContainer().isSideSolid(side);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return false;
        }
        return tile.getPartContainer().canPlaceTorchOnTop();
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.getPartContainer().randomDisplayTick(rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager particleManager) {
        PartMOP hit = this.reTrace(world, pos, MCMultiPartMod.proxy.getPlayer());
        if (hit != null) {
            TextureAtlasSprite icon;
            IBakedModel model;
            if (hit.partHit.addDestroyEffects(AdvancedParticleManager.getInstance(particleManager))) {
                return true;
            }
            ResourceLocation path = hit.partHit.getModelPath();
            IBlockState state = hit.partHit.getExtendedState(MultipartRegistry.getDefaultState(hit.partHit).getBaseState());
            IBakedModel iBakedModel = model = path == null ? null : Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getModel(new ModelResourceLocation(path, MultipartStateMapper.instance.getPropertyString((Map<IProperty<?>, Comparable<?>>)state.getProperties())));
            if (model != null && (icon = model.getParticleTexture()) != null) {
                AdvancedParticleManager.getInstance(particleManager).addBlockDestroyEffects(pos, icon);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager particleManager) {
        PartMOP hit;
        PartMOP partMOP = hit = target instanceof PartMOP ? (PartMOP)target : null;
        if (hit != null) {
            TextureAtlasSprite icon;
            IBakedModel model;
            if (hit.partHit.addHitEffects(hit, AdvancedParticleManager.getInstance(particleManager))) {
                return true;
            }
            ResourceLocation path = hit.partHit.getModelPath();
            IBlockState partState = hit.partHit.getExtendedState(MultipartRegistry.getDefaultState(hit.partHit).getBaseState());
            IBakedModel iBakedModel = model = path == null ? null : Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getModel(new ModelResourceLocation(path, MultipartStateMapper.instance.getPropertyString((Map<IProperty<?>, Comparable<?>>)partState.getProperties())));
            if (model != null && (icon = model.getParticleTexture()) != null) {
                AdvancedParticleManager.getInstance(particleManager).addBlockHitEffects(target.getBlockPos(), hit, this.bounds, icon);
            }
        }
        return true;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    private PartMOP reTrace(World world, BlockPos pos, EntityPlayer player) {
        Vec3d start = RayTraceUtils.getStart(player);
        Vec3d end = RayTraceUtils.getEnd(player);
        RayTraceUtils.AdvancedRayTraceResultPart result = this.getMultipartTile((IBlockAccess)world, pos).getPartContainer().collisionRayTrace(start, end);
        return result == null ? null : (PartMOP)result.hit;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isBlockNormalCube(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    public IExtendedBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        return ((IExtendedBlockState)state).withProperty(PROPERTY_MULTIPART_CONTAINER, tile != null ? tile.getPartContainer().getExtendedStates(world, pos) : new ArrayList());
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue(PROPERTY_TICKING) != false ? 0 : 1;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(PROPERTY_TICKING, (Comparable)Boolean.valueOf(meta == 0));
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, PROPERTIES, UNLISTED_PROPERTIES);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public final void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        PartMOP hit;
        PartMOP partMOP = hit = event.getTarget() instanceof PartMOP ? (PartMOP)event.getTarget() : null;
        if (hit != null && hit.partHit instanceof ICustomHighlightPart) {
            GlStateManager.pushMatrix();
            BlockPos pos = hit.getBlockPos();
            EntityPlayer player = event.getPlayer();
            float partialTicks = event.getPartialTicks();
            double x = (double)pos.getX() - (player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)partialTicks);
            double y = (double)pos.getY() - (player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)partialTicks);
            double z = (double)pos.getZ() - (player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)partialTicks);
            GlStateManager.translate((double)x, (double)y, (double)z);
            if (((ICustomHighlightPart)hit.partHit).drawHighlight(hit, player, partialTicks)) {
                event.setCanceled(true);
            }
            GlStateManager.popMatrix();
        }
    }
}

