/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.block;

import mcmultipart.capabilities.ISlottedCapabilityProvider;
import mcmultipart.capabilities.MultipartCapabilityHelper;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.microblock.IMicroblockContainerTile;
import mcmultipart.microblock.MicroblockContainer;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.PartSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileCoverable
extends TileEntity
implements IMicroblockContainerTile,
ISlottedCapabilityProvider {
    private MicroblockContainer container;

    @Override
    public World getWorldIn() {
        return this.getWorld();
    }

    @Override
    public BlockPos getPosIn() {
        return this.getPos();
    }

    @Override
    public MicroblockContainer getMicroblockContainer() {
        return this.container != null ? this.container : (this.container = new MicroblockContainer(this));
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return true;
    }

    @Override
    public void onMicroblocksChanged() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        return MultipartCapabilityHelper.hasCapability(this.container, capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object impl = super.getCapability(capability, facing);
        if (impl != null) {
            return (T)impl;
        }
        return MultipartCapabilityHelper.getCapability(this.container, capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, PartSlot slot, EnumFacing facing) {
        return this.container.hasCapability(capability, slot, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, PartSlot slot, EnumFacing facing) {
        return this.container.getCapability(capability, slot, facing);
    }

    public void onLoad() {
        super.onLoad();
        for (IMultipart iMultipart : this.getMicroblockContainer().getParts()) {
            iMultipart.onLoaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (IMultipart iMultipart : this.getMicroblockContainer().getParts()) {
            iMultipart.onUnloaded();
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        this.getMicroblockContainer().getPartContainer().writeToNBT(compound);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.getMicroblockContainer().getPartContainer().readFromNBT(compound);
    }

    public NBTTagCompound getUpdateTag() {
        return this.getMicroblockContainer().getPartContainer().writeToNBT(super.getUpdateTag());
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), this.getBlockMetadata(), this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bounds = super.getRenderBoundingBox().offset((double)(-this.getPosIn().getX()), (double)(-this.getPosIn().getY()), (double)(-this.getPosIn().getZ()));
        for (IMultipart iMultipart : this.getMicroblockContainer().getParts()) {
            AxisAlignedBB bb = iMultipart.getRenderBoundingBox();
            if (bb == null) continue;
            bounds = bounds.union(bb);
        }
        return bounds.offset((double)this.getPosIn().getX(), (double)this.getPosIn().getY(), (double)this.getPosIn().getZ());
    }
}

